package com.xebialabs.xlrelease.api.v1.impl

import com.xebialabs.xlrelease.api.internal.UserTokenResource
import com.xebialabs.xlrelease.api.v1.PersonalAccessTokenApi
import com.xebialabs.xlrelease.api.v1.forms.CreatePersonalAccessTokenForm
import com.xebialabs.xlrelease.domain.UserToken
import org.springframework.stereotype.Controller

@Controller
class PersonalAccessTokenApiImpl(userTokenResource: UserTokenResource) extends PersonalAccessTokenApi {

  override def createPersonalAccessToken(username: String,
                                         createPersonalAccessTokenForm: CreatePersonalAccessTokenForm): UserToken = {
    userTokenResource.generateUserToken(username, createPersonalAccessTokenForm)
  }

  override def createPersonalAccessToken(createPersonalAccessTokenForm: CreatePersonalAccessTokenForm): UserToken = {
    userTokenResource.generateUserToken(createPersonalAccessTokenForm)
  }

}
