package com.xebialabs.xlrelease.db.sql.transaction

import com.xebialabs.xlrelease.db.sql.SqlBuilder.{CommonDialect, Dialect, OracleDialect}
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.transaction.annotation.Isolation
import org.springframework.transaction.interceptor.{DefaultTransactionAttribute, TransactionAttribute, TransactionAttributeSource, TransactionInterceptor}

import java.lang.reflect.Method

class XlrTransactionInterceptor(@Qualifier("xlrRepositorySqlDialect") dialect: Dialect) extends TransactionInterceptor {
  override def getTransactionAttributeSource: TransactionAttributeSource = {
    new XlrTransactionAttributeSource(super.getTransactionAttributeSource, dialect)
  }
}

class XlrTransactionAttributeSource(original: TransactionAttributeSource, dialect: Dialect) extends TransactionAttributeSource {
  override def getTransactionAttribute(method: Method, targetClass: Class[_]): TransactionAttribute = {
    original.getTransactionAttribute(method, targetClass) match {
      case attribute: DefaultTransactionAttribute if method.isAnnotationPresent(classOf[IsReadOnly]) =>
        attribute.setIsolationLevel(getReadonlyIsolationLevel(dialect).value())
        attribute.setReadOnly(true)
        attribute
      case attribute => attribute
    }
  }

  def getReadonlyIsolationLevel(dialect: Dialect): Isolation = dialect match {
    case OracleDialect(_) => Isolation.READ_COMMITTED
    case CommonDialect(dbName) if dbName.contains("postgres") => Isolation.READ_COMMITTED
    case CommonDialect(dbName) if dbName.contains("h2") => Isolation.READ_COMMITTED
    case _ => Isolation.READ_UNCOMMITTED
  }
}
