package com.xebialabs.xlrelease.rest.mappers;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import org.springframework.stereotype.Component;
import com.fasterxml.jackson.core.exc.StreamConstraintsException;

import com.xebialabs.deployit.Exceptions;
import com.xebialabs.deployit.Sanitizer;

@Component
public class StreamConstraintsExceptionMapper implements ExceptionMapper<StreamConstraintsException> {

    public static final String MAX_STR_LENGTH_ERROR_MSG = "The specified string exceeds the maximum allowed string length. " +
            "Please reduce the string length and retry. " + "If further assistance is needed please reach out to customer support.";

    @Override
    public Response toResponse(StreamConstraintsException e) {
        String content = Exceptions.getAllMessages(e);
        boolean containsMaxStringLengthError = e.getMessage().contains("StreamReadConstraints.getMaxStringLength()");
        if (containsMaxStringLengthError) {
            content = MAX_STR_LENGTH_ERROR_MSG;
        }

        final Response.ResponseBuilder builder = Response.serverError().type(MediaType.TEXT_PLAIN);
        builder.entity(Sanitizer.sanitize(content));
        return builder.build();
    }
}
