package com.xebialabs.xlrelease.script.groovy

import grizzled.slf4j.Logging
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl
import org.springframework.stereotype.Component

import javax.script.ScriptEngine

@Component
class UnrestrictedGroovyEngineCreator extends GroovyEngineCreator with Logging {
  override def createEngine(restricted: Boolean): ScriptEngine = {
    logger.debug(s"Groovy sandbox plugin is not installed. Groovy engine [restricted: false] instance started.")
    new GroovyScriptEngineImpl()
  }
}
