package com.xebialabs.xlrelease.upgrade;

import java.util.ArrayList;
import java.util.List;

/**
 * Upgrade result.
 * Contains information if upgrade was performed and a list of upgrade warnings to be displayed when importing the release
 * (eg: fields whose values couldn't be resolved and set to a default value)
 */
public class UpgradeResult {

    private boolean upgraded;

    private List<String> warnings = new ArrayList<>();

    public UpgradeResult(final boolean upgraded, final List<String> warnings) {
        this.upgraded = upgraded;
        this.warnings = warnings;
    }

    public boolean isUpgraded() {
        return upgraded;
    }

    public void setUpgraded(final boolean upgraded) {
        this.upgraded = upgraded;
    }

    public List<String> getWarnings() {
        return warnings;
    }

    public void setWarnings(final List<String> warnings) {
        this.warnings = warnings;
    }
}
