/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks$;
import io.micrometer.core.annotation.Timed;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005I4Aa\u0002\u0005\u0001#!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0011\u00151\u0003\u0001\"\u0001(\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u0015)\u0007\u0001\"\u0001g\u0005M!\u0016m]6XCR\u001c\u0007.\u001a:t'\u0016\u0014h/[2f\u0015\tI!\"A\u0004tKJ4\u0018nY3\u000b\u0005-a\u0011!\u0003=me\u0016dW-Y:f\u0015\tia\"A\u0005yK\nL\u0017\r\\1cg*\tq\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\fa\u0002^1tWJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d\u0015\u0005Q!/\u001a9pg&$xN]=\n\u0005yY\"A\u0004+bg.\u0014V\r]8tSR|'/_\u0001\tKZ,g\u000e\u001e\"vgB\u0011\u0011\u0005J\u0007\u0002E)\u00111EC\u0001\u0007KZ,g\u000e^:\n\u0005\u0015\u0012#!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u00061A(\u001b8jiz\"2\u0001\u000b\u0016,!\tI\u0003!D\u0001\t\u0011\u0015A2\u00011\u0001\u001a\u0011\u0015y2\u00011\u0001!Q\t\u0019Q\u0006\u0005\u0002/s5\tqF\u0003\u00021c\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005I\u001a\u0014a\u00024bGR|'/\u001f\u0006\u0003iU\nQAY3b]NT!AN\u001c\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001O\u0001\u0004_J<\u0017B\u0001\u001e0\u0005%\tU\u000f^8xSJ,G-\u0001\u0006bI\u0012<\u0016\r^2iKJ$2!\u0010)S!\rq4)R\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0005kRLGNC\u0001C\u0003\u0011Q\u0017M^1\n\u0005\u0011{$aA*fiB\u0011a)\u0014\b\u0003\u000f.\u0003\"\u0001\u0013\u000b\u000e\u0003%S!A\u0013\t\u0002\rq\u0012xn\u001c;?\u0013\taE#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001d>\u0013aa\u0015;sS:<'B\u0001'\u0015\u0011\u0015\tF\u00011\u0001F\u0003\u0019!\u0018m]6JI\")1\u000b\u0002a\u0001\u000b\u00069q/\u0019;dQ\u0016\u0014\bF\u0001\u0003V!\t1f,D\u0001X\u0015\t\u0001\u0004L\u0003\u0002Z5\u0006!1m\u001c:f\u0015\tYF,\u0001\u0006nS\u000e\u0014x.\\3uKJT\u0011!X\u0001\u0003S>L!aX,\u0003\u000bQKW.\u001a3\u0002\u001bI,Wn\u001c<f/\u0006$8\r[3s)\ri$m\u0019\u0005\u0006#\u0016\u0001\r!\u0012\u0005\u0006'\u0016\u0001\r!\u0012\u0015\u0003\u000bU\u000ba\"\u001e9eCR,w+\u0019;dQ\u0016\u00148\u000fF\u0002>O\"DQ!\u0015\u0004A\u0002\u0015CQ!\u001b\u0004A\u0002u\nq\"\u001e9eCR,GmV1uG\",'o\u001d\u0015\u0003\rUC#\u0001\u00017\u0011\u00055\u0004X\"\u00018\u000b\u0005=,\u0014AC:uKJ,w\u000e^=qK&\u0011\u0011O\u001c\u0002\b'\u0016\u0014h/[2f\u0001")
public class TaskWatchersService {
    private final TaskRepository taskRepository;
    private final XLReleaseEventBus eventBus;

    @Timed
    public Set<String> addWatcher(String taskId, String watcher) {
        Object task = this.taskRepository.findById(taskId);
        Task original = (Task)CiCloneHelper.cloneCi(task);
        LockedTaskOperationChecks$.MODULE$.checkAddWatcher((Task)task);
        task.addWatcher(watcher);
        this.taskRepository.update((Task)task);
        this.eventBus.publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
        return task.getWatchers();
    }

    @Timed
    public Set<String> removeWatcher(String taskId, String watcher) {
        Object task = this.taskRepository.findById(taskId);
        Task original = (Task)CiCloneHelper.cloneCi(task);
        LockedTaskOperationChecks$.MODULE$.checkRemoveWatcher((Task)task);
        task.removeWatcher(watcher);
        this.taskRepository.update((Task)task);
        this.eventBus.publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
        return task.getWatchers();
    }

    @Timed
    public Set<String> updateWatchers(String taskId, Set<String> updatedWatchers) {
        Object task = this.taskRepository.findById(taskId);
        Task original = (Task)CiCloneHelper.cloneCi(task);
        LockedTaskOperationChecks$.MODULE$.checkUpdateWatchers((Task)task);
        task.setWatchers(updatedWatchers);
        this.taskRepository.update((Task)task);
        this.eventBus.publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
        return task.getWatchers();
    }

    @Autowired
    public TaskWatchersService(TaskRepository taskRepository, XLReleaseEventBus eventBus) {
        this.taskRepository = taskRepository;
        this.eventBus = eventBus;
    }
}

