package com.xebialabs.xlrelease.actors.kryoserializers

import com.esotericsoftware.kryo.kryo5.Kryo
import com.xebialabs.xlrelease.actors.kryoserializers.javakaffee._
import com.xebialabs.xlrelease.actors.kryoserializers.javakaffee.guava.ImmutableListSerializer
import com.xebialabs.xlrelease.actors.kryoserializers.javakaffee.jodatime._
import org.joda.time.{DateTime, Interval, LocalDate, LocalDateTime}

import java.util.GregorianCalendar

// magro / javakaffe / kryo-serializers:
object JavaKaffeeSerializers extends Registrar {
  override def apply(implicit kryo: Kryo): Unit = {
    UnmodifiableCollectionsSerializer.registerSerializers(kryo)
    SynchronizedCollectionsSerializer.registerSerializers(kryo)
    kryo.register(classOf[GregorianCalendar], new GregorianCalendarSerializer())
    kryo.register(classOf[DateTime], new JodaDateTimeSerializer())
    kryo.register(classOf[Interval], new JodaIntervalSerializer())
    kryo.register(classOf[LocalDate], new JodaLocalDateSerializer())
    kryo.register(classOf[LocalDateTime], new JodaLocalDateTimeSerializer())
    ImmutableListSerializer.registerSerializers(kryo)
  }
}
