package com.xebialabs.xlrelease.domain.tasks.customscript;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.tasks.BaseScriptTaskExecutor;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.scheduler.CustomScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.WorkManager;
import com.xebialabs.xlrelease.script.TaskSoftReference;

import static com.xebialabs.xlrelease.domain.CustomScriptTask.PYTHON_SCRIPT_PREFIX;
import static com.xebialabs.xlrelease.variable.VariableHelper.containsOnlyVariable;
import static scala.concurrent.duration.Duration.Zero;

@Component
public class CustomScriptTaskExecutor extends BaseScriptTaskExecutor<CustomScriptTask> {

    private static final Logger logger = LoggerFactory.getLogger(CustomScriptTaskExecutor.class);

    @Autowired
    public CustomScriptTaskExecutor(WorkManager workManager, TaskRepository taskRepository) {
        super(workManager, taskRepository);
    }

    @Override
    public Class<CustomScriptTask> getTaskClass() {
        return CustomScriptTask.class;
    }

    @Override
    public void execute(TaskSoftReference<CustomScriptTask> taskRef) {
        CustomScriptTask task = taskRef.get();
        if (!(task.isInProgress() || task.isAbortScriptInProgress())) {
            logger.info("Not executing script of task {} as it is {}", task, task.getStatus());
            return;
        }
        fixVariableMapping(task);
        CustomScriptTaskJob job = new CustomScriptTaskJob(taskRef);
        if (task.isAbortScriptInProgress()) {
            workManager.replace(job);
        } else {
            workManager.submit(job);
        }
    }

    /**
     * Fix for amex: REL-7138
     *
     * @param task The task to be used
     */
    private void fixVariableMapping(final CustomScriptTask task) {
        final Collection<PropertyDescriptor> outputProperties = task.getPythonScript().getOutputProperties();
        boolean updated = false;
        for (PropertyDescriptor propertyDescriptor : outputProperties) {
            String propertyName = propertyDescriptor.getName();
            String fqPropertyName = PYTHON_SCRIPT_PREFIX + propertyName;
            Object propertyValue = task.getPythonScript().getProperty(propertyName);

            if (propertyValue instanceof String
                    && containsOnlyVariable((String) propertyValue)
                    && !task.getVariableMapping().containsKey(fqPropertyName)) {
                logger.debug("adding variable pre 5.0 [{}] with value [{}]", fqPropertyName, propertyValue);
                task.getVariableMapping().put(fqPropertyName, (String) propertyValue);
                updated = true;
            }
        }
        if (updated) {
            taskRepository.update(task);
        }
    }
}
