package com.xebialabs.xlrelease.upgrade.liquibase

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.stereotype.Component

import javax.sql.DataSource

/**
  * Updates the row with id=4 for XLRelease 7.5.3 as is the 14 for upper versions. Fix for REL-6562
  */
@Component
class XLRelease753BeforeLiquibaseUpgrade @Autowired()(@Qualifier("xlrRepositoryDataSourceProxy") xlrRepositoryDataSource: DataSource,
                                                      var repositoryVersionService: RepositoryVersionService)
  extends BeforeUpgrade with Logging {

  override def xlReleaseVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "7.5.0#3")

  override def doUpgrade(): Unit = {
    logger.info("applying upgrade XLRelease753BeforeLiquibaseUpgrade")
    val connection = xlrRepositoryDataSource.getConnection
    try {
      connection.prepareStatement("UPDATE DATABASECHANGELOG SET ID = '14' WHERE ID = '4'").executeUpdate()
    } finally {
      connection.close()
    }
  }
}
