package com.xebialabs.xlrelease.builder

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry.getDescriptor
import com.xebialabs.deployit.plugin.api.reflect.Type.valueOf
import com.xebialabs.xlrelease.configuration.ArchivingSettings

object ArchivingSettingsBuilder {
  def newArchivingSettings() = new ArchivingSettingsBuilder
}

class ArchivingSettingsBuilder {
  private val archivingSettings: ArchivingSettings = getDescriptor(valueOf(classOf[ArchivingSettings]))
    .newInstance(ArchivingSettings.ARCHIVING_SETTINGS_ID)

  def withReleaseAgeToDeleteFromJcr(hours: Integer): ArchivingSettingsBuilder = {
    archivingSettings.setReleaseAgeToDeleteFromJcr(hours)
    this
  }

  def build(): ArchivingSettings = {
    val copy = new ArchivingSettings
    getDescriptor(valueOf(classOf[ArchivingSettings])).getPropertyDescriptors.forEach { pd =>
      pd.set(copy, pd.get(archivingSettings))
    }
    copy.setId(archivingSettings.getId)
    copy
  }

}
