package com.xebialabs.xlrelease.script

import com.xebialabs.overthere.OverthereExecutionOutputHandler
import org.slf4j.Logger

case class OutputHandler(log: String => Unit) extends OverthereExecutionOutputHandler {
  def handleChar(c: Char): Unit = log(c.toString)
  def handleLine(line: String): Unit = log(line)
}

object OutputHandler {
  def info(logger: Logger): OutputHandler = OutputHandler((l: String) => logger.info(l))
  def debug(logger: Logger): OutputHandler = OutputHandler((l: String) => logger.debug(l))
  def error(logger: Logger): OutputHandler = OutputHandler((l: String) => logger.error(l))
}
