package com.xebialabs.xlrelease.script

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind.CI
import com.xebialabs.deployit.plugin.api.reflect.{PropertyDescriptor, Type}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.domain.{Configuration, Task}
import com.xebialabs.xlrelease.script.XlrScriptContext._

import java.util
import java.util.{List => JList}
import javax.script.ScriptContext
import scala.jdk.CollectionConverters._

package object builder {

  implicit class XlrScripContextExtensions(xlrScriptContext: XlrScriptContext) {

    def addDomainObjects(task: Task): Unit = {
      val release = task.getRelease
      xlrScriptContext.setAttribute(ATTR_RELEASE, release, ScriptContext.ENGINE_SCOPE)
      xlrScriptContext.setAttribute(ATTR_PHASE, task.getPhase, ScriptContext.ENGINE_SCOPE)
      xlrScriptContext.setAttribute(ATTR_TASK, task, ScriptContext.ENGINE_SCOPE)
    }

    def addProperties(configurationItem: ConfigurationItem, properties: util.Collection[PropertyDescriptor]): Unit = {
      for (propertyDescriptor <- properties.asScala) {
        val propertyName = propertyDescriptor.getName
        if (ciIsSubTypeOfConfiguration(propertyDescriptor)) {
          xlrScriptContext.setAttribute(propertyName, getPropertiesMap(configurationItem, propertyName), ScriptContext.ENGINE_SCOPE)
        } else {
          xlrScriptContext.setAttribute(propertyName, configurationItem.getProperty(propertyName), ScriptContext.ENGINE_SCOPE)
          addBindingToSugarify(propertyName, CONTEXT_BINDINGS_TO_WRAP)
        }
      }
    }

    def addCiAsMap(propertyLabel: String, configurationItem: ConfigurationItem): Unit =
      xlrScriptContext.setAttribute(propertyLabel, getCiAsMap(configurationItem), ScriptContext.ENGINE_SCOPE)

    def addPropertyBindings(properties: util.Collection[PropertyDescriptor]): Unit =
      properties.forEach((pd: PropertyDescriptor) => addBindingToSugarify(pd.getName, CONTEXT_BINDINGS_TO_UNWRAP))


    private def addBindingToSugarify(bindingName: String, sugarifyType: String): Unit = {
      @SuppressWarnings(Array("unchecked"))
      var sugarifiedNames = xlrScriptContext.getAttribute(sugarifyType).asInstanceOf[JList[String]]
      if (sugarifiedNames == null) {
        sugarifiedNames = new util.ArrayList[String]
        xlrScriptContext.setAttribute(sugarifyType, sugarifiedNames, ScriptContext.ENGINE_SCOPE)
      }
      sugarifiedNames.add(bindingName)
    }

    private def ciIsSubTypeOfConfiguration(propertyDescriptor: PropertyDescriptor): Boolean =
      (propertyDescriptor.getKind eq CI) && propertyDescriptor.getReferencedType.isSubTypeOf(Type.valueOf(classOf[Configuration]))

    private def getCiAsMap(ciPropertyItem: ConfigurationItem): util.Map[String, AnyRef] =
      Option(ciPropertyItem).map(ciProperty => {
        val ciProperties = new util.HashMap[String, AnyRef]()
        ciProperties.put(CONFIGURATION_ID_PROPERTY_NAME, ciProperty.getId)
        val descriptor = ciProperty.getType.getDescriptor
        for (ciPropertyDescriptor <- descriptor.getPropertyDescriptors.asScala) {
          ciProperties.put(ciPropertyDescriptor.getName, ciProperty.getProperty(ciPropertyDescriptor.getName))
        }
        ciProperties
      }).orNull

    private def getPropertiesMap(configurationItem: ConfigurationItem, propertyName: String): util.Map[String, AnyRef] =
      getCiAsMap(configurationItem.getProperty(propertyName))
  }

}
