package com.xebialabs.xlrelease.upgrade

import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.deployit.security.UserService
import com.xebialabs.xlrelease.security.XLReleasePermissions
import com.xebialabs.xlrelease.service.{UserProfileService, XlrServiceLifecycle, XlrServiceLifecycleOrder}
import com.xebialabs.xlrelease.upgrade.common.ClassNameToString
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

import scala.util.Try

@Component
class UserInitializer(serverConfiguration: ServerConfiguration,
                      userService: UserService,
                      userProfileService: UserProfileService)
  extends XlrServiceLifecycle with Logging with ClassNameToString {

  private def createAdminUser(): Unit = {
    logger.debug("Initializing admin user")
    val userId = XLReleasePermissions.ADMIN_USERNAME
    val password = serverConfiguration.getAdminPassword
    userService.create(userId, password)
    userProfileService.ensureCreated(userId)
  }

  override def doStart(): Unit = {
    Try(userService.read(XLReleasePermissions.ADMIN_USERNAME)).recover {
      case _: NotFoundException =>
        createAdminUser()
    }
  }

  override def doStop(): Unit = {}

  override def getOrder: Int = XlrServiceLifecycleOrder.USER_INITIALIZER
}
