package com.xebialabs.xlrelease.actors

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.db.sql.DatabaseInfo
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.context.annotation.{Bean, Configuration, DependsOn, Description}

@Configuration
class ActorSystemConfiguration(xlrConfig: XlrConfig, @Qualifier("xlrDatabaseInformation") xlrDatabaseInformation: DatabaseInfo) {
  @Bean
  def managedActorRegistry: ManagedActorRegistry = ManagedActorRegistry

  @Bean
  @DependsOn(Array("beforeLiquibaseUpgrade"))
  @Description("ActorSystemHolder binds together ActorSystem and Spring Application context. " +
    "At the same time it serves as ActorFactory that is capable of creating Props that use Spring based actor producers")
  def actorSystemHolder(): ActorSystemHolder = {
    new ActorSystemHolder(xlrConfig, xlrDatabaseInformation)
  }
}
