package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.xlrelease.api.v1.views.ExplodedDescriptor;
import org.springframework.stereotype.Controller;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.api.v1.MetadataApi;

import java.util.List;

@Controller
public class MetadataApiImpl implements MetadataApi {
    @Override
    public ExplodedDescriptor findDescriptor(final Type type) {
        return new ExplodedDescriptor(DescriptorRegistry.getDescriptor(type));
    }

    public List<ExplodedDescriptor> listAll() {
        return DescriptorRegistry.getDescriptors().stream().map(ExplodedDescriptor::new).toList();
    }
}
