package com.xebialabs.xlrelease.api.v1.impl

import com.xebialabs.deployit.checks.Checks.checkArgument
import com.xebialabs.xlrelease.api.ApiService.DEFAULT_RESULTS_PER_PAGE
import com.xebialabs.xlrelease.api.v1.WorkflowApi
import com.xebialabs.xlrelease.api.v1.filter.WorkflowFilters
import com.xebialabs.xlrelease.api.v1.views.WorkflowOverview
import com.xebialabs.xlrelease.service.WorkflowService
import org.springframework.data.domain.{Page, PageRequest}
import org.springframework.stereotype.Controller

@Controller
class WorkflowApiImpl(workflowService: WorkflowService) extends WorkflowApi {

  override def searchWorkflows(workflowFilters: WorkflowFilters, page: Int, resultsPerPage: Int): Page[WorkflowOverview] = {
    checkArgument(resultsPerPage <= DEFAULT_RESULTS_PER_PAGE, "Number of results per page cannot be more than %d", DEFAULT_RESULTS_PER_PAGE)
    val pageable = PageRequest.of(page, resultsPerPage)
    workflowService.findBy(workflowFilters, pageable)
  }
}
