package com.xebialabs.xlrelease.dispatcher

import java.util.concurrent.{ForkJoinPool, ForkJoinWorkerThread, ThreadFactory}

class XlrDispatcherForkJoinWorkerThreadFactory(threadFactory: ThreadFactory with ForkJoinPool.ForkJoinWorkerThreadFactory)
  extends XlrDispatcherThreadFactory(threadFactory) with ForkJoinPool.ForkJoinWorkerThreadFactory {
  override def newThread(pool: ForkJoinPool): ForkJoinWorkerThread =
    XlrPreserveAccessControlContext.doPrivileged(() => threadFactory.newThread(pool))
}
