package com.xebialabs.xlrelease.reports.filters;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;

import static java.lang.System.identityHashCode;

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION, versioned = false, virtual = true, description = "Base reports filter")
public abstract class ReportFilter extends BaseConfigurationItem {
    public ReportFilter withId(String id) {
        setId(id);
        return this;
    }

    // -1 because for some reason we put -1 as filter IDs and this causes problems in CiHelper.getNestedCis
    // if/when we have unique IDs on each filter, this can be removed
    @Override
    public int hashCode() {
        return (id != null && !"-1".equals(id)) ? id.hashCode() : identityHashCode(this);
    }

    abstract public <T extends SqlBuilder<T>> void apply(T builder);
}
