package com.xebialabs.xlrelease.repository

import com.xebialabs.deployit.checks.Checks.IncorrectArgumentException
import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.api.v1.forms.FacetFilters
import com.xebialabs.xlrelease.domain.facet.Facet
import com.xebialabs.xlrelease.domain.{Release, Task}
import com.xebialabs.xlrelease.repository.FacetRepository.GenericFacetRepository
import com.xebialabs.xlrelease.service.{ArchivingService, CiIdService}
import com.xebialabs.xlrelease.utils.TypeHelper.getAllSubtypesOf
import grizzled.slf4j.Logging

import scala.jdk.CollectionConverters._
import scala.util.Try

class GenericFacetArchiveRepository(val ciIdService: CiIdService,
                                    archivingService: ArchivingService)
  extends GenericFacetRepository
    with FacetRepository.ForArchive with Logging {

  def get(facetId: String, facetType: Option[Type]): Facet =
    throw new UnsupportedOperationException("Not supported")

  override protected def doCreate(facet: Facet): Facet =
    throw new IncorrectArgumentException(s"Task with the ID '${facet.getTargetId}' does not exist or has been archived.")

  def delete(facetId: String, facetType: Option[Type]): Unit =
    throw new UnsupportedOperationException("Not supported")

  def update(facet: Facet): Facet =
    throw new UnsupportedOperationException("Not supported")

  def search(facetFilters: FacetFilters): Seq[Facet] = {
    facetFilters.setTypes(Option(facetFilters.getTypes).map(_.asScala.flatMap(getAllSubtypesOf)).getOrElse(Seq.empty).asJava)
    val containerId = if (facetFilters.getParentId != null) facetFilters.getParentId else facetFilters.getTargetId
    val release = archivingService.getRelease(Ids.releaseIdFrom(containerId))
    release.getAllTasks.asScala
      .filter(_.getId == facetFilters.getTargetId || !facetFilters.hasTargetId)
      .flatMap(_.getFacets.asScala)
      .filter(facet => facetFilters.getTypes.isEmpty || facetFilters.getTypes.contains(facet.getType))
      .toList
  }

  def exists(facetId: String, facetType: Option[Type]): Boolean = false

  def findAllFacetsByRelease(release: Release): Seq[Facet] =
    Try(search(new FacetFilters().withParentId(release.getId))).recover {
      case _: NotFoundException =>
        logger.warn(s"Facets not found for release [${release.getId}]")
        Seq.empty
    }.get

  def findAllFacetsByTask(task: Task): Seq[Facet] =
    Try(search(new FacetFilters().withTargetId(task.getId))).recover {
      case _: NotFoundException =>
        logger.warn(s"Facets not found for task [${task.getId}]")
        Seq.empty
    }.get
}
