package com.xebialabs.xlrelease.security

import java.util.concurrent.atomic.AtomicReference

object PermissionCheckerHolder {
  private val PERMISSION_CHECKER_HOLDER = new AtomicReference[PermissionChecker]

  def init(permissionChecker: PermissionChecker): Unit = {
    PERMISSION_CHECKER_HOLDER.getAndSet(permissionChecker)
  }

  def get(): PermissionChecker = PermissionCheckerHolder.PERMISSION_CHECKER_HOLDER.get
}
