package com.xebialabs.xlrelease.security

import com.xebialabs.deployit.security.permission.Permission

object XlrPermissionLabels {

  private val permissionLabels = Map(
    "admin" -> "Admin",
    "login" -> "Manage who can login into the application",
    "reports#view" -> "View Reports and Analytics",
    "report#view" -> "View report",
    "all#audit" -> "Audit data",
    "dashboard#create" -> "Create Custom dashboards",
    "dashboard#view" -> "View Insights",
    "dashboard#edit" -> "Edit Custom dashboards",
    "workflow#view_execution" -> "View workflow executions",
    "workflow#start_execution" -> "Start workflow execution",
    "workflow#abort_execution" -> "Abort workflow executions",
    "release#view" -> "View release",
    "release#edit" -> "Edit release",
    "release#edit_security" -> "Edit release security",
    "release#start" -> "Start release",
    "release#abort" -> "Abort release",
    "release#create" -> "Create release",
    "release#restart_phase" -> "Restart phase",
    "release#reassign_task" -> "Assign task ownership",
    "release#edit_task" -> "All task permissions",
    "release#edit_task_input_output_properties" -> "Edit task-specific properties",
    "release#edit_task_configuration_facet" -> "Edit reporting attributes",
    "release#edit_task_script" -> "Edit scripts",
    "release#edit_blackout" -> "Edit blackout periods",
    "release#edit_failure_handler" -> "Edit failure handlers",
    "release#edit_precondition" -> "Edit preconditions",
    "release#lock_task" -> "Lock tasks",
    "release#reassign_lock_task" -> "Assign locked task ownership",
    "release#task_transition" -> "Perform task transitions",
    "release#advance_task_transition" -> "Perform task transition in advance",
    "release#edit_task_tags" -> "Edit tags",
    "release#edit_task_attachments" -> "Manage attachments",
    "release#edit_task_description" -> "Edit title and description",
    "release#edit_task_dates" -> "Edit dates",
    "release#edit_task_flag" -> "Edit flag",
    "repo#edit" -> "Edit repository",
    "security#view" -> "View security",
    "security#edit" -> "Edit security",
    "security#view" -> "View security",
    "template#create" -> "Create template",
    "template#create_release" -> "Create release",
    "template#create_release_other_folder" -> "Create release in another folder",
    "template#view" -> "View templates",
    "template#edit" -> "Edit templates",
    "template#edit_security" -> "Edit template security",
    "template#edit_triggers" -> "Manage triggers",
    "template#edit_failure_handler" -> "Edit task failure handler",
    "template#edit_precondition" -> "Edit task precondition",
    "template#lock_task" -> "Lock task",
    "global_variables#edit" -> "Edit global variables",
    "folder#view" -> "View folder",
    "folder#edit" -> "Edit folder",
    "folder#view_security" -> "View teams and permissions",
    "folder#edit_security" -> "Edit teams and permissions",
    "folder#edit_teams" -> "Restricted edit of teams and permissions",
    "folder#edit_notifications" -> "Edit folder notifications",
    "folder#edit_variables" -> "Edit folder variables",
    "folder#create_top_level" -> "Create top level folders",
    "folder#edit_configuration" -> "Edit configuration",
    "folder#view_versions" -> "View versions",
    "folder#edit_versions" -> "Edit versions",
    "folder#apply_changes" -> "Apply Changes",
    "folder#generate_configuration" -> "Generate configuration",
    "global_calendar#edit_blackout" -> "Edit blackout periods",
    "risk_profile#edit" -> "Edit risk profiles",
    "delivery#view" -> "View Deliveries tab",
    "delivery#edit" -> "Edit deliveries",
    "delivery#edit_tracked_item" -> "Edit tracked items",
    "delivery_pattern#view" -> "View delivery patterns",
    "delivery_pattern#edit" -> "Edit delivery patterns",
    "group#view" -> "View release groups",
    "group#edit" -> "Edit release groups",
    "environment#edit" -> "Edit environments",
    "environment#view" -> "View environments",
    "application#view" -> "View applications",
    "application#edit" -> "Edit applications",
    "reservation#edit" -> "Edit environment reservations",
    "runner#registration" -> "Runner registration",
    "trigger#edit_trigger" -> "Manage triggers",
    "trigger#view_trigger" -> "View triggers",
    "app_pipelines#view" -> "View App pipelines tab",
    "app_pipelines#edit" -> "Manage app pipelines"
  )

  def getLabel(permission: String): String = {
    permissionLabels.getOrElse(permission, permission)
  }

  def getLabel(permission: Permission): String = {
    getLabel(permission.getPermissionName)
  }

  implicit class PermissionOperations(permission: Permission) {
    def label(): String = {
      XlrPermissionLabels.getLabel(permission)
    }
  }
}
