package com.xebialabs.xlrelease.spring.configuration

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.scheduler.{ExecutorsRegistry, RestartableExecutorService, RestartableScheduledExecutorService, XlrExecutors}
import com.xebialabs.xlrelease.spring.configuration.ExecutorNames._
import io.micrometer.core.instrument.MeterRegistry
import org.springframework.context.annotation.{Bean, Configuration};

@Configuration
class ExecutorsConfiguration(xlrConfig: XlrConfig, meterRegistry: MeterRegistry) {

  @Bean
  def executorsRegistry: ExecutorsRegistry.type = ExecutorsRegistry

  @Bean(Array(TASK_EXECUTION_EXECUTOR_NAME))
  def taskExecution: RestartableExecutorService = {
    val maxThreadsCount: Int = xlrConfig.executors.scheduler.maxThreadsCount
    XlrExecutors.newFixedThreadPool(TASK_EXECUTION_EXECUTOR_NAME, maxThreadsCount, meterRegistry, xlrConfig.taskSchedulerGraceShutdownPeriod)
  }

  @Bean(Array(RELEASE_TRIGGER_EXECUTOR_NAME))
  def triggerExecutor: RestartableScheduledExecutorService = {
    val maxThreadsCount: Int = xlrConfig.executors.releaseTrigger.maxThreadsCount
    val shutdownTimeout: Int = xlrConfig.executors.releaseTrigger.shutdownTimeout
    XlrExecutors.newScheduledThreadPool(RELEASE_TRIGGER_EXECUTOR_NAME, maxThreadsCount, meterRegistry, shutdownTimeout)
  }

  @Bean(Array(QUARTZ_JOB_EXECUTOR_NAME))
  def quartzJobExecutor: RestartableScheduledExecutorService = {
    val maxThreadsCount: Int = xlrConfig.executors.quartzJobExecutor.maxThreadsCount
    val shutdownTimeout: Int = xlrConfig.executors.quartzJobExecutor.shutdownTimeout
    XlrExecutors.newScheduledThreadPool(QUARTZ_JOB_EXECUTOR_NAME, maxThreadsCount, meterRegistry, shutdownTimeout)
  }

  @Bean(Array(TIMEOUT_EXECUTOR_NAME))
  def timeoutExecutor: RestartableScheduledExecutorService = {
    lazy val maxThreadsCount: Int = xlrConfig.executors.timeoutExecutor.maxThreadsCount
    lazy val shutdownTimeout: Int = xlrConfig.executors.timeoutExecutor.shutdownTimeout
    XlrExecutors.newScheduledThreadPool(TIMEOUT_EXECUTOR_NAME, maxThreadsCount, meterRegistry, shutdownTimeout)
  }

  @Bean(Array(POLLING_EXECUTOR_NAME))
  def pollingExecutor: RestartableScheduledExecutorService = {
    lazy val maxThreadsCount: Int = xlrConfig.executors.pollingExecutor.maxThreadsCount
    lazy val shutdownTimeout: Int = xlrConfig.executors.pollingExecutor.shutdownTimeout
    XlrExecutors.newScheduledThreadPool(POLLING_EXECUTOR_NAME, maxThreadsCount, meterRegistry, shutdownTimeout)
  }

  @Bean(Array(LOG_FLUSH_EXECUTOR_NAME))
  def logFlushExecutor: RestartableScheduledExecutorService = {
    lazy val maxThreadsCount: Int = xlrConfig.executors.logFlushExecutor.maxThreadsCount
    lazy val shutdownTimeout: Int = xlrConfig.executors.logFlushExecutor.shutdownTimeout
    XlrExecutors.newScheduledThreadPool(LOG_FLUSH_EXECUTOR_NAME, maxThreadsCount, meterRegistry, shutdownTimeout)
  }

  @Bean(Array(AUXILIARY_EXECUTOR_NAME))
  def auxiliaryExecutor: RestartableScheduledExecutorService = {
    lazy val maxThreadsCount: Int = xlrConfig.executors.auxiliaryExecutor.maxThreadsCount
    lazy val shutdownTimeout: Int = xlrConfig.executors.auxiliaryExecutor.shutdownTimeout
    XlrExecutors.newScheduledThreadPool(AUXILIARY_EXECUTOR_NAME, maxThreadsCount, meterRegistry, shutdownTimeout)
  }

  @Bean(Array(PRE_ARCHIVING_EXECUTOR_NAME))
  def preArchivingExecutor: RestartableScheduledExecutorService = {
    lazy val maxThreadsCount: Int = xlrConfig.executors.preArchivingExecutor.maxThreadsCount
    lazy val shutdownTimeout: Int = xlrConfig.executors.preArchivingExecutor.shutdownTimeout
    XlrExecutors.newScheduledThreadPool(PRE_ARCHIVING_EXECUTOR_NAME, maxThreadsCount, meterRegistry, shutdownTimeout)
  }

  @Bean(Array(SSE_EVENTS_EXECUTOR_NAME))
  def sseEventsExecutor: RestartableScheduledExecutorService = {
    lazy val maxThreadsCount: Int = xlrConfig.executors.sseEvents.maxThreadsCount
    lazy val shutdownTimeout: Int = xlrConfig.executors.sseEvents.shutdownTimeout
    XlrExecutors.newScheduledThreadPool(SSE_EVENTS_EXECUTOR_NAME, maxThreadsCount, meterRegistry, shutdownTimeout)
  }

  // TODO missing executor services:
  //  - "report-executor"
  //  - "risk-calculation"
  //  - "risk-calculation-batch"

}