package com.xebialabs.xlrelease.views

import com.fasterxml.jackson.databind.annotation.{JsonDeserialize, JsonSerialize}
import com.google.common.collect.Lists.newArrayList
import com.xebialabs.xlrelease.domain._
import com.xebialabs.xlrelease.serialization.json.jackson.{DomainIdDeserializer, DomainIdSerializer}
import com.xebialabs.xlrelease.views.converters.DurationViewConverter.toDurationView

import java.lang.{Long => JLong}
import java.util.{Date, List => JList}
import scala.beans.BeanProperty


object ReleaseTreeItem {
  def apply(item: PlanItem): ReleaseTreeItem = {
    val treeItem = new ReleaseTreeItem
    treeItem.setId(item.getId)
    treeItem.setStartDate(item.getStartDate)
    treeItem.setEndDate(item.getEndDate)
    treeItem.setScheduledStartDate(item.getScheduledStartDate)
    treeItem.setDueDate(item.getDueDate)
    if (item.getPlannedDuration != null) {
      treeItem.setPlannedDuration(toDurationView(item.getPlannedDuration))
    }
    treeItem.setType(item.getType.toString)
    treeItem.setActive(item.isActive)
    if (item.hasProperty("automated")) {
      treeItem.setAutomated(item.getProperty[Boolean]("automated"))
    }
    treeItem
  }
}

class ReleaseTreeItem {
  @JsonSerialize(using = classOf[DomainIdSerializer])
  @JsonDeserialize(using = classOf[DomainIdDeserializer])
  @BeanProperty var id: String = _
  @BeanProperty var scheduledStartDate: Date = null
  @BeanProperty var dueDate: Date = null
  @BeanProperty var startDate: Date = null
  @BeanProperty var endDate: Date = null
  @BeanProperty var plannedDuration: JLong = null
  private var `type`: String = _
  @BeanProperty var children: JList[ReleaseTreeItem] = null
  @BeanProperty var dependencies: JList[DependencyView] = null
  @BeanProperty var active: Boolean = _
  @BeanProperty var automated: Boolean = _
  @BeanProperty var links: JList[LinkView] = null

  def getType = `type`

  def setType(t: String) = `type` = t

  def isCompleted: Boolean = {
    startDate != null && endDate != null
  }

  def hasPlannedDates: Boolean = {
    plannedDuration != null || dueDate != null
  }
}

class ReleaseTree {
  @JsonSerialize(using = classOf[DomainIdSerializer])
  @JsonDeserialize(using = classOf[DomainIdDeserializer])
  @BeanProperty var releaseId: String = _
  @BeanProperty var dependentReleases: JList[ReleaseTreeItem] = newArrayList()
}
