package com.xebialabs.xlrelease.views;

import com.xebialabs.deployit.engine.api.security.RolePrincipals;

import java.util.ArrayList;
import java.util.List;

import static java.util.stream.Collectors.toList;

public class RolePrincipalsView {
    private RoleView role;
    private List<UserView> principals = new ArrayList<>();

    public RolePrincipalsView() {
    }

    public RolePrincipalsView(RoleView roleview, List<UserView> rolePrincipalsView) {
        this.role = roleview;
        this.principals = rolePrincipalsView;
    }

    public RoleView getRole() {
        return role;
    }

    public void setRole(RoleView role) {
        this.role = role;
    }

    public List<UserView> getPrincipals() {
        return principals;
    }

    public void setPrincipals(List<UserView> principals) {
        this.principals = principals;
    }

    public RolePrincipals toRolePrincipals() {
        return new RolePrincipals(role.toRole(), principals.stream().map(UserView::getUsername).collect(toList()));
    }
}
