/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal.converters;

import com.xebialabs.xlrelease.configuration.CustomLogoContentType;
import com.xebialabs.xlrelease.configuration.CustomLogoSettings;
import com.xebialabs.xlrelease.views.CustomLogoSettingsView;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Safelist;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Using;
import scala.util.Using$;

@Component
@ScalaSignature(bytes="\u0006\u0005E4A\u0001C\u0005\u0001-!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0013\u0011\u0003BB\u0017\u0001A\u0003%1\u0005C\u0003/\u0001\u0011\u0005q\u0006C\u0003P\u0001\u0011\u0005\u0001\u000bC\u0003Z\u0001\u0011%!\fC\u0003e\u0001\u0011%QMA\u000eDkN$x.\u001c'pO>\u001cV\r\u001e;j]\u001e\u001c8i\u001c8wKJ$XM\u001d\u0006\u0003\u0015-\t!bY8om\u0016\u0014H/\u001a:t\u0015\taQ\"\u0001\u0005j]R,'O\\1m\u0015\tqq\"A\u0002ba&T!\u0001E\t\u0002\u0013ad'/\u001a7fCN,'B\u0001\n\u0014\u0003%AXMY5bY\u0006\u00147OC\u0001\u0015\u0003\r\u0019w.\\\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003%\t1b\u001d<h'\u00064W\rT5tiV\t1\u0005\u0005\u0002%W5\tQE\u0003\u0002'O\u000511/\u00194fifT!\u0001K\u0015\u0002\u000b)\u001cx.\u001e9\u000b\u0003)\n1a\u001c:h\u0013\taSE\u0001\u0005TC\u001a,G.[:u\u00031\u0019hoZ*bM\u0016d\u0015n\u001d;!\u0003\u00111'o\\7\u0015\tA24)\u0012\t\u0003cQj\u0011A\r\u0006\u0003g=\tQbY8oM&<WO]1uS>t\u0017BA\u001b3\u0005I\u0019Uo\u001d;p[2{wm\\*fiRLgnZ:\t\u000b]\"\u0001\u0019\u0001\u001d\u0002\u0011\u0019LG.\u001a(b[\u0016\u0004\"!\u000f!\u000f\u0005ir\u0004CA\u001e\u001a\u001b\u0005a$BA\u001f\u0016\u0003\u0019a$o\\8u}%\u0011q(G\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%AB*ue&twM\u0003\u0002@3!)A\t\u0002a\u0001q\u0005Y1m\u001c8uK:$H+\u001f9f\u0011\u00151E\u00011\u0001H\u0003-Ig\u000e];u'R\u0014X-Y7\u0011\u0005!kU\"A%\u000b\u0005)[\u0015AA5p\u0015\u0005a\u0015\u0001\u00026bm\u0006L!AT%\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\u0007i>4\u0016.Z<\u0015\u0005E;\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+\u0010\u0003\u00151\u0018.Z<t\u0013\t16K\u0001\fDkN$x.\u001c'pO>\u001cV\r\u001e;j]\u001e\u001ch+[3x\u0011\u0015AV\u00011\u00011\u0003I\u0019Wo\u001d;p[2{wm\\*fiRLgnZ:\u0002\u001bM\fg.\u001b;ju\u0016LU.Y4f)\rY\u0016M\u0019\t\u00041qs\u0016BA/\u001a\u0005\u0015\t%O]1z!\tAr,\u0003\u0002a3\t!!)\u001f;f\u0011\u0015!e\u00011\u00019\u0011\u0015\u0019g\u00011\u0001\\\u0003%IW.Y4f\t\u0006$\u0018-A\u0006tC:LG/\u001b>f'Z<GC\u0001\u001dg\u0011\u00159w\u00011\u00019\u0003)\u0019hoZ\"p]R,g\u000e\u001e\u0015\u0003\u0001%\u0004\"A[8\u000e\u0003-T!\u0001\\7\u0002\u0015M$XM]3pif\u0004XM\u0003\u0002oS\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148.\u0003\u0002qW\nI1i\\7q_:,g\u000e\u001e")
public class CustomLogoSettingsConverter {
    private final Safelist svgSafeList = Safelist.basic().addTags(new String[]{"svg", "g", "path", "rect", "circle", "ellipse", "line", "polyline", "polygon", "text", "tspan"}).addAttributes(":all", new String[]{"style", "fill", "stroke", "d", "width", "height", "viewBox", "x", "y", "r", "cx", "cy", "points", "transform"}).addProtocols("xlink:href", "http", new String[]{"https"});

    private Safelist svgSafeList() {
        return this.svgSafeList;
    }

    public CustomLogoSettings from(String fileName, String contentType, InputStream inputStream) {
        ObjectRef customLogoSettings = ObjectRef.create(null);
        Using$.MODULE$.resource((Object)inputStream, (Function1 & Serializable)imageInFile -> {
            CustomLogoSettingsConverter.$anonfun$from$1(this, contentType, customLogoSettings, fileName, imageInFile);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        return (CustomLogoSettings)customLogoSettings.elem;
    }

    public CustomLogoSettingsView toView(CustomLogoSettings customLogoSettings) {
        byte[] imageByteArray = Base64.getDecoder().decode(customLogoSettings.getContent());
        return new CustomLogoSettingsView(customLogoSettings.getFilename(), customLogoSettings.getContentType(), imageByteArray);
    }

    private byte[] sanitizeImage(String contentType, byte[] imageData) {
        byte[] byArray;
        String string = contentType;
        String string2 = CustomLogoContentType.IMAGE_SVG_XML.value();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String imageContent = this.sanitizeSvg(new String(imageData, StandardCharsets.UTF_8));
            byArray = imageContent.getBytes(StandardCharsets.UTF_8);
        } else {
            byArray = imageData;
        }
        byte[] sanitizedContent = byArray;
        return sanitizedContent;
    }

    private String sanitizeSvg(String svgContent) {
        return Jsoup.clean((String)svgContent, (String)"", (Safelist)this.svgSafeList(), (Document.OutputSettings)new Document.OutputSettings().prettyPrint(false));
    }

    public static final /* synthetic */ void $anonfun$from$1(CustomLogoSettingsConverter $this, String contentType$1, ObjectRef customLogoSettings$1, String fileName$1, InputStream imageInFile) {
        int in = -1;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while ((in = imageInFile.read()) != -1) {
            buffer.write(in);
        }
        byte[] imageData = buffer.toByteArray();
        imageInFile.read(imageData);
        byte[] sanitizedContent = $this.sanitizeImage(contentType$1, imageData);
        customLogoSettings$1.elem = new CustomLogoSettings();
        ((CustomLogoSettings)customLogoSettings$1.elem).setFilename(fileName$1);
        ((CustomLogoSettings)customLogoSettings$1.elem).setContentType(contentType$1);
        ((CustomLogoSettings)customLogoSettings$1.elem).setContent(Base64.getEncoder().encodeToString(sanitizedContent));
    }
}

