/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.RolesApi;
import com.xebialabs.xlrelease.api.v1.filters.RolePrincipalsFilters;
import com.xebialabs.xlrelease.api.v1.views.PrincipalView;
import com.xebialabs.xlrelease.api.v1.views.RoleView;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.ReleaseRoleService;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.views.RolePrincipalsView;
import io.micrometer.core.annotation.Timed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.CacheManager;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;

@Controller
public class RolesApiImpl
implements RolesApi {
    private static final Logger logger = LoggerFactory.getLogger(RolesApiImpl.class);
    private final PermissionChecker permissions;
    private final ReleaseRoleService releaseRoleService;
    private final Optional<CacheManager> cacheManager;

    public RolesApiImpl(PermissionChecker permissions, ReleaseRoleService releaseRoleService, @Qualifier(value="securityCacheManager") Optional<CacheManager> cacheManager) {
        this.permissions = permissions;
        this.releaseRoleService = releaseRoleService;
        this.cacheManager = cacheManager;
    }

    @Timed
    public List<RoleView> searchRoles(RolePrincipalsFilters filters, Integer page, Integer resultsPerPage) {
        logger.trace("Entering getRoles(page={}, resultsPerPage={})", (Object)page, (Object)resultsPerPage);
        this.invalidateCachesIfNecessary();
        this.permissions.checkAny(PlatformPermissions.EDIT_SECURITY, PlatformPermissions.VIEW_SECURITY, XLReleasePermissions.AUDIT_ALL);
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage);
        List rolePrincipalsViews = this.releaseRoleService.getGlobalRolePrincipalViews(filters, (Pageable)pageable).getContent();
        String[] roleIds = (String[])rolePrincipalsViews.stream().map(r -> r.getRole().getId()).toArray(String[]::new);
        Map<String, Set<String>> allRolePermissions = this.releaseRoleService.getGlobalRolePermissions(roleIds);
        List<RoleView> result = rolePrincipalsViews.stream().map(rolePrincipalsView -> this.assembleRoleView((RolePrincipalsView)rolePrincipalsView, allRolePermissions)).toList();
        logger.trace("Exiting getRoles(page={}, resultsPerPage={}). Found {} roles. Results:\n{}", new Object[]{page, resultsPerPage, result.size(), result});
        return result;
    }

    @Timed
    public RoleView getRole(String roleName) {
        logger.trace("Entering getRole(roleName={})", (Object)roleName);
        this.invalidateCachesIfNecessary();
        this.permissions.checkAny(PlatformPermissions.EDIT_SECURITY, PlatformPermissions.VIEW_SECURITY, XLReleasePermissions.AUDIT_ALL);
        RolePrincipalsView rolePrincipalsView = this.releaseRoleService.getGlobalRolePrincipalsView(roleName);
        String roleId = rolePrincipalsView.getRole().getId();
        Set<String> rolePermissions = this.releaseRoleService.getRolePermissions(roleId);
        RoleView result = this.assembleRoleView(rolePrincipalsView, Map.of(roleId, rolePermissions));
        logger.trace("Exiting getRole(roleName={}). Result:\n{}", (Object)roleName, (Object)result);
        return result;
    }

    @Timed
    public void create(String roleName, RoleView roleView) {
        logger.trace("Entering create(roleName={}, role={})", (Object)roleName, (Object)roleView);
        this.invalidateCachesIfNecessary();
        this.permissions.check(PlatformPermissions.EDIT_SECURITY);
        Checks.checkTrue((boolean)roleName.equals(roleView.getName()), (String)"Role name '%s' given in the path is not equal to the role '%s' defined in the provided object", (Object[])new Object[]{roleName, roleView.getName()});
        this.create(Collections.singletonList(roleView));
        logger.trace("Exiting create(roleName={}, role={})", (Object)roleName, (Object)roleView);
    }

    @Timed
    public void create(List<RoleView> roleViews) {
        logger.trace("Entering create(roles={})", roleViews);
        this.invalidateCachesIfNecessary();
        this.permissions.check(PlatformPermissions.EDIT_SECURITY);
        this.checkPermissions(roleViews);
        List<String> lowerRoleNames = roleViews.stream().map(roleView -> roleView.getName().trim().toLowerCase()).toList();
        Optional<Role> role = this.releaseRoleService.getGlobalRoles().stream().filter(r -> lowerRoleNames.contains(r.getName().trim().toLowerCase())).findFirst();
        if (role.isPresent()) {
            throw new ItemAlreadyExistsException("Role '%s' already exist. Maybe you wanted to update it?", new Object[]{role.get().getName()});
        }
        ArrayList createRequests = new ArrayList();
        roleViews.forEach(roleView -> {
            String roleName = roleView.getName().trim();
            Set<String> rolePrincipals = roleView.getPrincipals().stream().map(PrincipalView::getUsername).collect(Collectors.toSet());
            Set rolePermissions = roleView.getPermissions();
            ReleaseRoleService.RoleCreateRequest r = new ReleaseRoleService.RoleCreateRequest(roleName, rolePrincipals, rolePermissions);
            createRequests.add(r);
        });
        this.releaseRoleService.createGlobalRoleAndRolePermissions(createRequests.toArray(new ReleaseRoleService.RoleCreateRequest[0]));
        logger.trace("Exiting create(roles={})", roleViews);
    }

    @Timed
    public void update(String roleName, RoleView roleView) {
        logger.trace("Entering update(roleName={}, roles={})", (Object)roleName, (Object)roleView);
        this.invalidateCachesIfNecessary();
        this.permissions.check(PlatformPermissions.EDIT_SECURITY);
        roleView.setName(roleName);
        this.update(Collections.singletonList(roleView));
        logger.trace("Exiting update(roleName={}, roles={})", (Object)roleName, (Object)roleView);
    }

    @Timed
    public void update(List<RoleView> roleViews) {
        logger.trace("Entering update(roles={})", roleViews);
        this.invalidateCachesIfNecessary();
        this.permissions.check(PlatformPermissions.EDIT_SECURITY);
        this.checkPermissions(roleViews);
        List<String> roleNamesToUpdate = roleViews.stream().map(roleView -> roleView.getName().trim().toLowerCase()).toList();
        List<Role> roles = this.releaseRoleService.getGlobalRoles();
        Map rolesByName = (Map)roles.stream().collect(com.xebialabs.xlrelease.utils.Collectors.toMap(role -> role.getName().trim().toLowerCase(), Function.identity()));
        Optional<String> firstNonExistent = roleNamesToUpdate.stream().filter(r -> !rolesByName.containsKey(r)).findFirst();
        if (firstNonExistent.isPresent()) {
            throw new LogFriendlyNotFoundException("Role '%s' does not exist. Maybe you wanted to create it?", new Object[]{firstNonExistent.get()});
        }
        ArrayList updateRequests = new ArrayList();
        roleViews.forEach(roleView -> {
            String roleName = roleView.getName().trim();
            String roleId = ((Role)rolesByName.get(roleName.toLowerCase())).getId();
            Set<String> rolePrincipals = roleView.getPrincipals().stream().map(PrincipalView::getUsername).collect(Collectors.toSet());
            ReleaseRoleService.RoleUpdateRequest r = new ReleaseRoleService.RoleUpdateRequest(roleId, roleName, rolePrincipals, roleView.getPermissions());
            updateRequests.add(r);
        });
        this.releaseRoleService.updateGlobalRoleAndRolePermissions(updateRequests.toArray(new ReleaseRoleService.RoleUpdateRequest[0]));
        logger.trace("Exiting update(roles={})", roleViews);
    }

    @Timed
    public void delete(String roleName) {
        logger.trace("Entering delete(roleName={})", (Object)roleName);
        this.invalidateCachesIfNecessary();
        this.permissions.check(PlatformPermissions.EDIT_SECURITY);
        this.releaseRoleService.deleteGlobalRole(roleName);
        logger.trace("Exiting delete(roleName={})", (Object)roleName);
    }

    @Timed
    public void rename(String roleName, String newName) {
        logger.trace("Entering rename(roleName={}, newName={})", (Object)roleName, (Object)newName);
        this.invalidateCachesIfNecessary();
        this.permissions.check(PlatformPermissions.EDIT_SECURITY);
        if (!this.releaseRoleService.globalRoleExists(roleName)) {
            throw new LogFriendlyNotFoundException("Role '%s' does not exist. Maybe you wanted to create it first?", new Object[]{roleName});
        }
        if (this.releaseRoleService.globalRoleExists(newName)) {
            throw new ItemAlreadyExistsException("Role '%s' already exist.", new Object[]{newName});
        }
        this.releaseRoleService.renameGlobalRole(roleName, newName);
        logger.trace("Exiting rename(roleName={}, newName={})", (Object)roleName, (Object)newName);
    }

    private RoleView assembleRoleView(RolePrincipalsView rolePrincipalsView, Map<String, Set<String>> rolePermissions) {
        RoleView roleView = new RoleView();
        String roleId = rolePrincipalsView.getRole().getId();
        roleView.setId(roleId);
        roleView.setName(rolePrincipalsView.getRole().getName());
        roleView.setPrincipals(rolePrincipalsView.getPrincipals().stream().map(userView -> {
            PrincipalView principalView = new PrincipalView();
            principalView.setUsername(userView.getUsername());
            principalView.setFullname(userView.getFullName());
            return principalView;
        }).toList());
        Set rolePermissionsOrDefault = rolePermissions.getOrDefault(roleId, Collections.emptySet());
        roleView.setPermissions(new HashSet(rolePermissionsOrDefault));
        return roleView;
    }

    private void checkPermissions(List<RoleView> roleViewList) {
        TreeSet unknownPermissions = new TreeSet();
        roleViewList.forEach(roleView -> unknownPermissions.addAll(roleView.getPermissions().stream().filter(p -> Permission.find((String)p) == null).toList()));
        Checks.checkArgument((boolean)unknownPermissions.isEmpty(), (String)"Unknown permissions found: '%s'", (Object[])new Object[]{String.join((CharSequence)", ", unknownPermissions)});
        HashSet allPermissions = new HashSet();
        roleViewList.forEach(roleView -> allPermissions.addAll(roleView.getPermissions().stream().map(Permission::find).filter(Objects::nonNull).toList()));
        Collection notApplicableTo = Permissions.isApplicableTo(allPermissions, (String)PermissionChecker.GLOBAL_SECURITY_ALIAS(), (boolean)false);
        Checks.checkArgument((boolean)notApplicableTo.isEmpty(), (String)"Not applicable permissions found: '%s'", (Object[])new Object[]{notApplicableTo.stream().map(Permission::getPermissionName).collect(Collectors.joining(", "))});
    }

    private void invalidateCachesIfNecessary() {
        try {
            this.cacheManager.ifPresent(manager -> manager.getCacheNames().forEach(cache -> manager.getCache(cache).invalidate()));
        }
        catch (Exception e) {
            logger.warn("Unable to clear security cache before operation", (Throwable)e);
        }
    }
}

