/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.builder.DependencyBuilder;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseRepository;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyCandidateCollector;
import com.xebialabs.xlrelease.service.IdAndStatus;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseTreeBuilder;
import com.xebialabs.xlrelease.service.TaskConcurrencyService;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.ReleaseTreeItem;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\tMg\u0001B\u0017/\u0001]B\u0001\"\u0014\u0001\u0003\u0006\u0004%\tA\u0014\u0005\t+\u0002\u0011\t\u0011)A\u0005\u001f\"Aa\u000b\u0001BC\u0002\u0013\u0005q\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003Y\u0011!a\u0006A!b\u0001\n\u0003i\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u0011\t\u0004!Q1A\u0005\u0002\rD\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tQ\u0002\u0011)\u0019!C\u0001S\"A\u0001\u000f\u0001B\u0001B\u0003%!\u000e\u0003\u0005r\u0001\t\u0015\r\u0011\"\u0001s\u0011!1\bA!A!\u0002\u0013\u0019\b\u0002C<\u0001\u0005\u000b\u0007I\u0011\u0001=\t\u0011q\u0004!\u0011!Q\u0001\neD\u0001\" \u0001\u0003\u0006\u0004%\tA \u0005\n\u0003\u000b\u0001!\u0011!Q\u0001\n}D!\"a\u0002\u0001\u0005\u000b\u0007I\u0011AA\u0005\u0011)\t\t\u0002\u0001B\u0001B\u0003%\u00111\u0002\u0005\u000b\u0003'\u0001!Q1A\u0005\u0002\u0005U\u0001BCA\u000f\u0001\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u0011q\u0004\u0001\u0003\u0006\u0004%\t!!\t\t\u0015\u0005=\u0002A!A!\u0002\u0013\t\u0019\u0003C\u0004\u00022\u0001!\t!a\r\t\u0013\u0005-\u0004A1A\u0005\u0002\u00055\u0004\u0002CAL\u0001\u0001\u0006I!a\u001c\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\"9\u0011q\u001a\u0001\u0005\u0002\u0005E\u0007bBAh\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0003k\u0004A\u0011AA|\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005#AqA!\n\u0001\t\u0003\u00119\u0003C\u0004\u0003.\u0001!\tAa\f\t\u000f\t\u001d\u0003\u0001\"\u0001\u0003J!9!\u0011\u000b\u0001\u0005\u0002\tM\u0003b\u0002B.\u0001\u0011\u0005!Q\f\u0005\b\u0005G\u0002A\u0011\u0002B3\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0005[BqAa \u0001\t\u0003\u0011\t\tC\u0004\u0003\f\u0002!\tA!$\t\u000f\tm\u0005\u0001\"\u0003\u0003\u001e\"9!\u0011\u0015\u0001\u0005\n\t\r\u0006b\u0002BV\u0001\u0011E!Q\u0016\u0005\b\u0005g\u0003A\u0011\u0003B[\u0011\u001d\u0011I\f\u0001C\t\u0005w\u0013\u0011\u0003R3qK:$WM\\2z'\u0016\u0014h/[2f\u0015\ty\u0003'A\u0004tKJ4\u0018nY3\u000b\u0005E\u0012\u0014!\u0003=me\u0016dW-Y:f\u0015\t\u0019D'A\u0005yK\nL\u0017\r\\1cg*\tQ'A\u0002d_6\u001c\u0001aE\u0003\u0001qy\u0012U\t\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$H\u0001\u0004B]f\u0014VM\u001a\t\u0003\u007f\u0001k\u0011AL\u0005\u0003\u0003:\u0012!CU3mK\u0006\u001cX\r\u0016:fK\n+\u0018\u000e\u001c3feB\u0011qhQ\u0005\u0003\t:\u0012A\u0004R3qK:$WM\\2z\u0007\u0006tG-\u001b3bi\u0016\u001cu\u000e\u001c7fGR|'\u000f\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u0006)1\u000f\u001c45U*\t!*\u0001\u0005he&T(\u0010\\3e\u0013\tauIA\u0004M_\u001e<\u0017N\\4\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u00180F\u0001P!\t\u00016+D\u0001R\u0015\t\u0011\u0006'\u0001\u0006sKB|7/\u001b;pefL!\u0001V)\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180\u0001\nsK2,\u0017m]3SKB|7/\u001b;pef\u0004\u0013\u0001\u0006:fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW-F\u0001Y!\ty\u0014,\u0003\u0002[]\t!\"+\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\fQC]3mK\u0006\u001cXmU3be\u000eD7+\u001a:wS\u000e,\u0007%\u0001\nqY\u0006t\u0017\n^3n%\u0016\u0004xn]5u_JLX#\u00010\u0011\u0005A{\u0016B\u00011R\u0005I\u0001F.\u00198Ji\u0016l'+\u001a9pg&$xN]=\u0002'Ad\u0017M\\%uK6\u0014V\r]8tSR|'/\u001f\u0011\u0002)\u0011,\u0007/\u001a8eK:\u001c\u0017PU3q_NLGo\u001c:z+\u0005!\u0007C\u0001)f\u0013\t1\u0017K\u0001\u000bEKB,g\u000eZ3oGf\u0014V\r]8tSR|'/_\u0001\u0016I\u0016\u0004XM\u001c3f]\u000eL(+\u001a9pg&$xN]=!\u0003!)g/\u001a8u\u0005V\u001cX#\u00016\u0011\u0005-tW\"\u00017\u000b\u00055\u0004\u0014AB3wK:$8/\u0003\u0002pY\nAQI^3oi\n+8/A\u0005fm\u0016tGOQ;tA\u0005qA/Y:l%\u0016\u0004xn]5u_JLX#A:\u0011\u0005A#\u0018BA;R\u00059!\u0016m]6SKB|7/\u001b;pef\fq\u0002^1tWJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0010a\"\f7/\u001a*fa>\u001c\u0018\u000e^8ssV\t\u0011\u0010\u0005\u0002Qu&\u001110\u0015\u0002\u0010!\"\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006\u0001\u0002\u000f[1tKJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\fG&LEmU3sm&\u001cW-F\u0001\u0000!\ry\u0014\u0011A\u0005\u0004\u0003\u0007q#aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\fAbY5JIN+'O^5dK\u0002\n\u0001#\u0019:dQ&4\u0018N\\4TKJ4\u0018nY3\u0016\u0005\u0005-\u0001cA \u0002\u000e%\u0019\u0011q\u0002\u0018\u0003!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,\u0017!E1sG\"Lg/\u001b8h'\u0016\u0014h/[2fA\u00051B/Y:l\u0007>t7-\u001e:sK:\u001c\u0017pU3sm&\u001cW-\u0006\u0002\u0002\u0018A\u0019q(!\u0007\n\u0007\u0005maF\u0001\fUCN\\7i\u001c8dkJ\u0014XM\\2z'\u0016\u0014h/[2f\u0003]!\u0018m]6D_:\u001cWO\u001d:f]\u000eL8+\u001a:wS\u000e,\u0007%A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW-\u0006\u0002\u0002$A!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*A\na!Y2u_J\u001c\u0018\u0002BA\u0017\u0003O\u00111CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\fAC]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\r\u00026\u0005]\u0012\u0011HA\u001e\u0003{\ty$!\u0011\u0002D\u0005\u0015\u0013qIA%\u0003\u0017\u0002\"a\u0010\u0001\t\u000b5;\u0002\u0019A(\t\u000bY;\u0002\u0019\u0001-\t\u000bq;\u0002\u0019\u00010\t\u000b\t<\u0002\u0019\u00013\t\u000b!<\u0002\u0019\u00016\t\u000bE<\u0002\u0019A:\t\u000b]<\u0002\u0019A=\t\u000bu<\u0002\u0019A@\t\u000f\u0005\u001dq\u00031\u0001\u0002\f!9\u00111C\fA\u0002\u0005]\u0001bBA\u0010/\u0001\u0007\u00111\u0005\u0015\u0004/\u0005=\u0003\u0003BA)\u0003Oj!!a\u0015\u000b\t\u0005U\u0013qK\u0001\u000bC:tw\u000e^1uS>t'\u0002BA-\u00037\nqAZ1di>\u0014\u0018P\u0003\u0003\u0002^\u0005}\u0013!\u00022fC:\u001c(\u0002BA1\u0003G\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003K\n1a\u001c:h\u0013\u0011\tI'a\u0015\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001G1di&4X\rR3qK:$WM\\2z'R\fG/^:fgV\u0011\u0011q\u000e\t\u0007\u0003c\n\t)a\"\u000f\t\u0005M\u0014Q\u0010\b\u0005\u0003k\nY(\u0004\u0002\u0002x)\u0019\u0011\u0011\u0010\u001c\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0014bAA@u\u00059\u0001/Y2lC\u001e,\u0017\u0002BAB\u0003\u000b\u00131aU3r\u0015\r\tyH\u000f\t\u0005\u0003\u0013\u000b\tJ\u0004\u0003\u0002\f\u00065\u0005cAA;u%\u0019\u0011q\u0012\u001e\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019*!&\u0003\rM#(/\u001b8h\u0015\r\tyIO\u0001\u001aC\u000e$\u0018N^3EKB,g\u000eZ3oGf\u001cF/\u0019;vg\u0016\u001c\b%\u0001\u0004de\u0016\fG/\u001a\u000b\u0007\u0003;\u000bI+a-\u0011\t\u0005}\u0015QU\u0007\u0003\u0003CS1!a)1\u0003\u0019!w.\\1j]&!\u0011qUAQ\u0005)!U\r]3oI\u0016t7-\u001f\u0005\b\u0003WS\u0002\u0019AAW\u0003\u00119\u0017\r^3\u0011\t\u0005}\u0015qV\u0005\u0005\u0003c\u000b\tK\u0001\u0005HCR,G+Y:l\u0011\u001d\t)L\u0007a\u0001\u0003\u000f\u000b!\u0003^1sO\u0016$\u0018\nZ(s-\u0006\u0014\u0018.\u00192mK\"\u001a!$!/\u0011\t\u0005m\u00161Z\u0007\u0003\u0003{SA!!\u0016\u0002@*!\u0011\u0011YAb\u0003\u0011\u0019wN]3\u000b\t\u0005\u0015\u0017qY\u0001\u000b[&\u001c'o\\7fi\u0016\u0014(BAAe\u0003\tIw.\u0003\u0003\u0002N\u0006u&!\u0002+j[\u0016$\u0017\u0001D;qI\u0006$X\rV1sO\u0016$H\u0003CAO\u0003'\f9.!7\t\u000f\u0005U7\u00041\u0001\u0002\b\u0006aA-\u001a9f]\u0012,gnY=JI\"9\u0011QW\u000eA\u0002\u0005\u001d\u0005bBAn7\u0001\u0007\u0011Q\\\u0001\u000b[>$\u0017NZ5fI\u0006#\b\u0003BAp\u0003Sl!!!9\u000b\t\u0005\r\u0018Q]\u0001\u0005i&lWM\u0003\u0003\u0002h\u0006\r\u0014\u0001\u00026pI\u0006LA!a;\u0002b\nAA)\u0019;f)&lW\r\u0006\u0004\u0002\u001e\u0006=\u0018\u0011\u001f\u0005\b\u0003+d\u0002\u0019AAD\u0011\u001d\t)\f\ba\u0001\u0003\u000fC3\u0001HA]\u0003\u0019!W\r\\3uKR1\u0011\u0011`A\u0000\u0005\u0013\u00012!OA~\u0013\r\tiP\u000f\u0002\u0005+:LG\u000fC\u0004\u0003\u0002u\u0001\rAa\u0001\u0002\u000fI,G.Z1tKB!\u0011q\u0014B\u0003\u0013\u0011\u00119!!)\u0003\u000fI+G.Z1tK\"9!1B\u000fA\u0002\u0005\u001d\u0015AA5eQ\ri\u0012\u0011X\u0001\u0016O\u0016$8i\\7qY\u0016$\u0018M\u00197f\u000f\u0006$X-\u00133t)\u0011\tyGa\u0005\t\u000f\tUa\u00041\u0001\u0003\u0018\u00059A/\u0019:hKR\u001c\bCBAE\u00053\u0011i\"\u0003\u0003\u0003\u001c\u0005U%aA*fiB!\u0011q\u0014B\u0010\u0013\u0011\u0011\t#!)\u0003\u0011Ac\u0017M\\%uK6D3AHA]\u0003e1W\r^2i\t\u0016\u0004XM\u001c3f]R|\u0005/\u001a8HCR,\u0017\nZ:\u0015\t\u0005=$\u0011\u0006\u0005\b\u0005+y\u0002\u0019\u0001B\fQ\ry\u0012\u0011X\u0001\u001aM&tG-Q2uSZ,\u0017J\\2p[&twmR1uK&#7\u000f\u0006\u0003\u00032\t\u0005\u0003C\u0002B\u001a\u0005{\t9)\u0004\u0002\u00036)!!q\u0007B\u001d\u0003\u0011)H/\u001b7\u000b\u0005\tm\u0012\u0001\u00026bm\u0006LAAa\u0010\u00036\t!A*[:u\u0011\u001d\u0011\u0019\u0005\ta\u0001\u0003\u000f\u000b\u0011B]3mK\u0006\u001cX-\u00133)\u0007\u0001\nI,\u0001\u0010gS:$\u0017i\u0019;jm\u0016LenY8nS:<G)\u001a9f]\u0012,gnY5fgR!!1\nB'!\u0019\t\t(!!\u0002\u001e\"9!qJ\u0011A\u0002\u0005\u001d\u0015\u0001\u00039be\u0016tG/\u00133\u0002%\u001d,GOR1jY\u0006\u0014G.Z$bi\u0016LEm\u001d\u000b\u0005\u0003_\u0012)\u0006C\u0004\u0003X\t\u0002\rAa\u0006\u0002\u001d\u0005\u0014wN\u001d;fIR\u000b'oZ3ug\"\u001a!%!/\u00027\u0019Lg\u000eZ!di&4XmT;uO>Lgn\u001a+be\u001e,G/\u00133t)\u0011\u0011\tDa\u0018\t\u000f\t\r3\u00051\u0001\u0002\b\"\u001a1%!/\u00023\u0019Lg\u000eZ!di&4XmT;uO>Lgn\u001a+be\u001e,Go\u001d\u000b\u0005\u0005O\u0012I\u0007\u0005\u0004\u0002r\u0005\u0005%Q\u0004\u0005\b\u0005\u0007\"\u0003\u0019AAD\u000399W\r\u001e*fY\u0016\f7/\u001a+sK\u0016$BAa\u001c\u0003|A!!\u0011\u000fB<\u001b\t\u0011\u0019HC\u0002\u0003vA\nQA^5foNLAA!\u001f\u0003t\tY!+\u001a7fCN,GK]3f\u0011\u001d\u0011\u0019%\na\u0001\u0003\u000fC3!JA]\u0003M\t'o\u00195jm\u0016$U\r]3oI\u0016t7-[3t)\u0019\tIPa!\u0003\u0006\"9!1\t\u0014A\u0002\u0005\u001d\u0005b\u0002BDM\u0001\u0007\u0011qN\u0001\u000eI\u0016\u0004XM\u001c3f]\u000eL\u0018\nZ:)\u0007\u0019\nI,\u0001\u0010gS:$G)\u001a9f]\u0012,gnY=UCJ<W\r\u001e\"z)\u0006\u0014x-\u001a;JIR!!q\u0012BK!\ry$\u0011S\u0005\u0004\u0005's#aC%e\u0003:$7\u000b^1ukNDqAa&(\u0001\u0004\t9)\u0001\u0005uCJ<W\r^%eQ\r9\u0013\u0011X\u0001\nO\u0016$8\u000b^1ukN$B!a\"\u0003 \"9!q\u0013\u0015A\u0002\u0005\u001d\u0015AF;qI\u0006$X\rV1sO\u0016$H)\u001a9f]\u0012,gnY=\u0015\u0011\u0005u%Q\u0015BT\u0005SCq!!6*\u0001\u0004\t9\tC\u0004\u00026&\u0002\r!a\"\t\u000f\u0005-\u0016\u00061\u0001\u0002.\u0006ib-\u001b8e\u0013:\u0004&o\\4sKN\u001c\u0018J\\2p[&twmR1uK&#7\u000f\u0006\u0003\u0002p\t=\u0006b\u0002BYU\u0001\u0007\u0011qN\u0001\ni\u0006\u0014x-\u001a;JIN\fqBZ5oI>\u0003XM\\$bi\u0016LEm\u001d\u000b\u0005\u0003_\u00129\fC\u0004\u00032.\u0002\r!a\u001c\u0002\u0015%\u001cH+Z7qY\u0006$X\r\u0006\u0003\u0003>\n\r\u0007cA\u001d\u0003@&\u0019!\u0011\u0019\u001e\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u001b\u0017A\u0002\u0005\u001d\u0005f\u0001\u0001\u0003HB!!\u0011\u001aBh\u001b\t\u0011YM\u0003\u0003\u0003N\u0006}\u0013AC:uKJ,w\u000e^=qK&!!\u0011\u001bBf\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class DependencyService
implements ReleaseTreeBuilder,
DependencyCandidateCollector,
Logging {
    private final ReleaseRepository releaseRepository;
    private final ReleaseSearchService releaseSearchService;
    private final PlanItemRepository planItemRepository;
    private final DependencyRepository dependencyRepository;
    private final EventBus eventBus;
    private final TaskRepository taskRepository;
    private final PhaseRepository phaseRepository;
    private final CiIdService ciIdService;
    private final ArchivingService archivingService;
    private final TaskConcurrencyService taskConcurrencyService;
    private final ReleaseActorService releaseActorService;
    private final scala.collection.immutable.Seq<String> activeDependencyStatuses;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public java.util.List<Dependency> findByReleaseId(String releaseId) {
        return DependencyCandidateCollector.findByReleaseId$(this, releaseId);
    }

    @Override
    @Timed
    public java.util.List<Release> findAllDependencyCandidates(String gateId) {
        return DependencyCandidateCollector.findAllDependencyCandidates$(this, gateId);
    }

    @Override
    @Timed
    public Release getDependencyCandidate(String gateId, String targetReleaseId) {
        return DependencyCandidateCollector.getDependencyCandidate$(this, gateId, targetReleaseId);
    }

    @Override
    public scala.collection.immutable.Seq<String> getReferencedCis(String gateReleaseId) {
        return DependencyCandidateCollector.getReferencedCis$(this, gateReleaseId);
    }

    @Override
    public boolean isReferencable(PlanItem planItem, scala.collection.immutable.Seq<String> referencedIds) {
        return DependencyCandidateCollector.isReferencable$(this, planItem, referencedIds);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, Map<String, ReleaseTreeItem> dependentReleases, PlanItem item) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, item);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, Map<String, ReleaseTreeItem> dependentReleases, TaskGroup taskGroup) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, taskGroup);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, Map<String, ReleaseTreeItem> dependentReleases, GateTask gateTask) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, gateTask);
    }

    @Override
    public Object loadDependentRelease(Dependency dependency, String releaseId, Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.loadDependentRelease$(this, dependency, releaseId, dependentReleases);
    }

    @Override
    public PartialFunction<Task, ReleaseTreeItem> taskMatcher(String releaseId, Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.taskMatcher$(this, releaseId, dependentReleases);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    public PlanItemRepository planItemRepository() {
        return this.planItemRepository;
    }

    @Override
    public DependencyRepository dependencyRepository() {
        return this.dependencyRepository;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public PhaseRepository phaseRepository() {
        return this.phaseRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public TaskConcurrencyService taskConcurrencyService() {
        return this.taskConcurrencyService;
    }

    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    public scala.collection.immutable.Seq<String> activeDependencyStatuses() {
        return this.activeDependencyStatuses;
    }

    @Timed
    public Dependency create(GateTask gate, String targetIdOrVariable) {
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't add a dependency to a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkCreateDependency((Task)gate);
        Dependency dependency = DependencyBuilder.newDependency().withId(this.ciIdService().getUniqueId(Type.valueOf(Dependency.class), gate.getId())).build();
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
        } else {
            Object target = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTarget(target);
        }
        gate.addDependency(dependency);
        dependency.setGateTask(gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().create(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyCreatedEvent(dependency));
        return dependency;
    }

    public Dependency updateTarget(String dependencyId, String targetIdOrVariable, DateTime modifiedAt) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        this.taskConcurrencyService().checkConcurrentModification((Task)gate, modifiedAt);
        return this.updateTargetDependency(dependencyId, targetIdOrVariable, gate);
    }

    @Timed
    public Dependency updateTarget(String dependencyId, String targetIdOrVariable) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        return this.updateTargetDependency(dependencyId, targetIdOrVariable, gate);
    }

    @Timed
    public void delete(Release release, String id) {
        Option maybeDependency = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(x$2.getDependencies()).asScala())).find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DependencyService.$anonfun$delete$2(id, x$3)));
        Dependency dependency = (Dependency)maybeDependency.getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Repository entity [" + id + "] not found", new Object[0]);
        });
        GateTask gate = dependency.getGateTask();
        LockedTaskOperationChecks$.MODULE$.checkDeleteDependency((Task)gate);
        Checks.checkArgument((!dependency.isDone() || gate.isPlanned() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be deleted", (Object[])new Object[0]);
        this.dependencyRepository().delete(dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyDeletedEvent(dependency));
    }

    @Timed
    public scala.collection.immutable.Seq<String> getCompletableGateIds(Set<PlanItem> targets) {
        scala.collection.immutable.Seq doneTargetIds = ((IterableOnceOps)((IterableOps)targets.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDone()))).map((Function1 & Serializable)x$5 -> x$5.getId())).toSeq();
        this.logger().trace((Function0 & Serializable)() -> "getCompletableGateIds doneTargetIds: " + doneTargetIds.mkString(", "));
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)doneTargetIds).map((Function1 & Serializable)id -> {
            GateTask item = (GateTask)this.taskRepository().findById((String)id);
            this.logger().trace((Function0 & Serializable)() -> "getCompletableGateIds item " + item.getId() + ": hasConditions = " + item.hasConditions() + ", hasDependencies = " + item.hasDependencies() + ", isOpen = " + item.isOpen() + ", status = " + item.getStatus());
            return item;
        })).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isCompletable()))).map((Function1 & Serializable)x$7 -> x$7.getId());
    }

    @Timed
    public scala.collection.immutable.Seq<String> fetchDependentOpenGateIds(Set<PlanItem> targets) {
        scala.collection.immutable.Seq targetIds = ((IterableOnceOps)targets.map((Function1 & Serializable)x$8 -> x$8.getId())).toSeq();
        this.logger().trace((Function0 & Serializable)() -> "fetchDependentOpenGateIds targetIds: " + targetIds.mkString(", "));
        return this.findOpenGateIds((scala.collection.immutable.Seq<String>)targetIds);
    }

    @Timed
    public java.util.List<String> findActiveIncomingGateIds(String releaseId) {
        Seq seq;
        if (this.releaseRepository().exists(releaseId)) {
            seq = (Seq)((SeqOps)this.findActiveIncomingDependencies(releaseId).map((Function1 & Serializable)dep -> Ids.getParentId((String)dep.getId()))).distinct();
        } else {
            this.logger().debug((Function0 & Serializable)() -> "Release " + releaseId + " not found. It is either archived, or does not exist. Returning no dependencies");
            seq = (Seq)package$.MODULE$.Seq().empty();
        }
        return CollectionConverters$.MODULE$.SeqHasAsJava(seq).asJava();
    }

    public scala.collection.immutable.Seq<Dependency> findActiveIncomingDependencies(String parentId) {
        return this.dependencyRepository().findAllIncomingDependencies((scala.collection.immutable.Seq<String>)new .colon.colon((Object)parentId, (List)Nil$.MODULE$), this.activeDependencyStatuses(), true, false);
    }

    @Timed
    public scala.collection.immutable.Seq<String> getFailableGateIds(Set<PlanItem> abortedTargets) {
        return this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)((IterableOnceOps)abortedTargets.map((Function1 & Serializable)x$9 -> x$9.getId())).toSeq());
    }

    @Timed
    public java.util.List<String> findActiveOutgoingTargetIds(String releaseId) {
        java.util.List targetIds = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.findActiveOutgoingTargets(releaseId).map((Function1 & Serializable)x$10 -> x$10.getId())).asJava();
        return targetIds;
    }

    private scala.collection.immutable.Seq<PlanItem> findActiveOutgoingTargets(String releaseId) {
        java.util.List<Dependency> dependencies = this.findByReleaseId(releaseId);
        scala.collection.immutable.Seq targets = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(dependencies).asScala().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Dependency, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                if (A12 != null && (A1 = A12).hasResolvedTarget() && !A1.isDone()) {
                    return (B1)A1.getTarget();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Dependency x1) {
                Dependency dependency;
                Dependency dependency2 = x1;
                return dependency2 != null && (dependency = dependency2).hasResolvedTarget() && !dependency.isDone();
            }
        })).toSeq();
        return targets;
    }

    @Timed
    public ReleaseTree getReleaseTree(String releaseId) {
        if (this.archivingService().exists(releaseId)) {
            return new ReleaseTree();
        }
        Map dependentReleases = (Map)Map$.MODULE$.empty();
        Release release = this.releaseRepository().findById(releaseId);
        this.toTreeItem(releaseId, (Map<String, ReleaseTreeItem>)dependentReleases, (PlanItem)release);
        ReleaseTree tree = new ReleaseTree();
        tree.releaseId_$eq(releaseId);
        tree.dependentReleases_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)dependentReleases.values().toList()).asJava());
        return tree;
    }

    @Timed
    public void archiveDependencies(String releaseId, scala.collection.immutable.Seq<String> dependencyIds) {
        Release referencingRelease = this.releaseRepository().findById(releaseId);
        Buffer dependenciesToArchive = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(referencingRelease.getAllGates()).asScala().flatMap((Function1 & Serializable)x$11 -> CollectionConverters$.MODULE$.ListHasAsScala(x$11.getDependencies()).asScala())).filter((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)dependencyIds.contains((Object)d.getId())));
        dependenciesToArchive.foreach((Function1 & Serializable)x$12 -> {
            x$12.archive();
            return BoxedUnit.UNIT;
        });
        this.dependencyRepository().archive(referencingRelease, (scala.collection.immutable.Seq<Dependency>)dependenciesToArchive.toSeq());
    }

    @Timed
    public IdAndStatus findDependencyTargetByTargetId(String targetId) {
        return new IdAndStatus(targetId, this.getStatus(targetId));
    }

    private String getStatus(String targetId) {
        Option option;
        Option option2;
        Option option3;
        String string = targetId;
        if (string != null && !(option3 = IdMatchers.ReleaseId$.MODULE$.unapply(string)).isEmpty()) {
            return (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.releaseRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        return (B1)this.$outer.archivingService().getRelease(this.targetId$1).getStatus().toString();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return throwable != null;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException("Release [" + targetId + "] not found", new Object[0]);
            });
        }
        if (string != null && !(option2 = IdMatchers.PhaseId$.MODULE$.unapply(string)).isEmpty()) {
            return (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.phaseRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 != null) {
                        return (B1)this.$outer.archivingService().getPhase(this.targetId$1).getStatus().toString();
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Throwable throwable = x2;
                    return throwable != null;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException("Phase [" + targetId + "] not found", new Object[0]);
            });
        }
        if (string != null && !(option = IdMatchers.TaskId$.MODULE$.unapply(string)).isEmpty()) {
            return (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.taskRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1 != null) {
                        return (B1)this.$outer.archivingService().getTask(this.targetId$1).getStatus().toString();
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(Throwable x3) {
                    Throwable throwable = x3;
                    return throwable != null;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException("Task [" + targetId + "] not found", new Object[0]);
            });
        }
        throw new NotFoundException("Target is not plan item, targetId= " + targetId, new Object[0]);
    }

    private Dependency updateTargetDependency(String dependencyId, String targetIdOrVariable, GateTask gate) {
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't edit a dependency on a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkUpdateDependency((Task)gate);
        Dependency dependency = gate.getDependencies().stream().filter(d -> {
            String string = dependencyId;
            String string2 = d.getId();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).findFirst().orElseThrow(() -> new NotFoundException(String.format("Dependency with Id '%s' not found.", dependencyId), new Object[0]));
        Dependency original = CiCloneHelper.cloneCi(dependency);
        Checks.checkArgument((!dependency.isDone() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be updated", (Object[])new Object[0]);
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(null);
        } else {
            Object newTarget = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(newTarget);
        }
        this.taskConcurrencyService().updateLastModifiedDetails((Task)gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().update(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, dependency));
        return dependency;
    }

    public scala.collection.immutable.Seq<String> findInProgressIncomingGateIds(scala.collection.immutable.Seq<String> targetIds) {
        return (scala.collection.immutable.Seq)((SeqOps)this.dependencyRepository().findAllIncomingDependencies(targetIds, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)TaskStatus.IN_PROGRESS.name(), (List)Nil$.MODULE$), false, this.dependencyRepository().findAllIncomingDependencies$default$4()).map((Function1 & Serializable)dep -> Ids.getParentId((String)dep.getId()))).distinct();
    }

    public scala.collection.immutable.Seq<String> findOpenGateIds(scala.collection.immutable.Seq<String> targetIds) {
        return (scala.collection.immutable.Seq)((SeqOps)this.dependencyRepository().findAllIncomingDependencies(targetIds, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)TaskStatus.IN_PROGRESS.name(), (List)new .colon.colon((Object)TaskStatus.FAILING.name(), (List)Nil$.MODULE$)), false, this.dependencyRepository().findAllIncomingDependencies$default$4()).map((Function1 & Serializable)dep -> Ids.getParentId((String)dep.getId()))).distinct();
    }

    public boolean isTemplate(String dependencyId) {
        return this.releaseRepository().isTemplate(Ids.releaseIdFrom((String)dependencyId));
    }

    public static final /* synthetic */ boolean $anonfun$delete$2(String id$1, Dependency x$3) {
        String string = x$3.getId();
        String string2 = Ids.normalizeId((String)id$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public DependencyService(ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, PlanItemRepository planItemRepository, DependencyRepository dependencyRepository, EventBus eventBus, TaskRepository taskRepository, PhaseRepository phaseRepository, CiIdService ciIdService, ArchivingService archivingService, TaskConcurrencyService taskConcurrencyService, ReleaseActorService releaseActorService) {
        this.releaseRepository = releaseRepository;
        this.releaseSearchService = releaseSearchService;
        this.planItemRepository = planItemRepository;
        this.dependencyRepository = dependencyRepository;
        this.eventBus = eventBus;
        this.taskRepository = taskRepository;
        this.phaseRepository = phaseRepository;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        this.taskConcurrencyService = taskConcurrencyService;
        this.releaseActorService = releaseActorService;
        ReleaseTreeBuilder.$init$(this);
        DependencyCandidateCollector.$init$(this);
        Logging.$init$((Logging)this);
        this.activeDependencyStatuses = (scala.collection.immutable.Seq)((IterableOps)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])TaskStatus.ACTIVE_STATUSES)).$colon$plus((Object)TaskStatus.PLANNED)).map((Function1 & Serializable)x$1 -> x$1.name());
    }
}

