/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.export;

import com.xebialabs.deployit.core.xml.PasswordEncryptingCiConverter;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.serialization.ConfigurationItemReferenceResolver;
import com.xebialabs.deployit.plumbing.serialization.PortableConfigurationReference;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class UnresolvedReferencesConfigurationItemConverter
extends PasswordEncryptingCiConverter
implements ConfigurationItemReferenceResolver {
    public static final String DECRYPTION_FAILED_VALUE = UnresolvedReferencesConfigurationItemConverter.class.getName() + ".DECRYPTION_FAILED_VALUE";
    private ResolutionContext resolutionContext;
    private ConfigurationRepository configurationRepository;
    private static final Logger logger = LoggerFactory.getLogger(UnresolvedReferencesConfigurationItemConverter.class);

    public UnresolvedReferencesConfigurationItemConverter(ConfigurationRepository configurationRepository, ResolutionContext resolutionContext) {
        this.configurationRepository = configurationRepository;
        this.resolutionContext = resolutionContext;
    }

    protected void writeCiProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        BaseConfiguration ci;
        Option<PortableConfigurationReference> portableConfigurationReference;
        if (value instanceof BaseConfiguration && (portableConfigurationReference = PortableConfigurationReference.from(ci = (BaseConfiguration)value)).nonEmpty()) {
            writer.ciReference(((PortableConfigurationReference)portableConfigurationReference.get()).portableReferenceId());
            return;
        }
        super.writeCiProperty(value, propertyDescriptor, writer);
    }

    protected void readStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
        if (propertyDescriptor.isPassword()) {
            try {
                super.readStringProperty(configurationItem, propertyDescriptor, reader);
            }
            catch (Exception exception) {
                propertyDescriptor.set(configurationItem, (Object)DECRYPTION_FAILED_VALUE);
                logger.info("Failed to read password field: '{}' with value: '{}'", new Object[]{propertyDescriptor, reader.getStringValue(), exception});
            }
        } else {
            super.readStringProperty(configurationItem, propertyDescriptor, reader);
        }
    }

    public void resolveReferences(Repository repository) {
        this.resolveReferencesWithFallback(repository);
    }

    @Override
    public ConfigurationRepository getConfigurationRepository() {
        return this.configurationRepository;
    }

    @Override
    public ResolutionContext getResolutionContext() {
        return this.resolutionContext;
    }
}

