/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.calendar;

import com.google.common.base.Preconditions;
import com.xebialabs.xlrelease.domain.Release;
import java.util.Date;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;

public class ReleaseCalendar {
    private final String id;
    private final String title;
    private final Date scheduledStartDate;
    private final Date dueDate;
    private final String description;
    private Calendar calendar;

    public ReleaseCalendar(Release release) {
        Preconditions.checkState((release.getScheduledStartDate() != null && release.getDueDate() != null ? 1 : 0) != 0, (String)"Can't generate ICS file for release '%s', because it does not have start date or due date.", (Object)release.getTitle());
        this.id = release.getId();
        this.title = release.getTitle();
        this.scheduledStartDate = release.getScheduledStartDate();
        this.dueDate = release.getDueDate();
        this.description = release.getDescription();
        this.generateCalendar();
    }

    private void generateCalendar() {
        this.calendar = this.getCalendar();
        VEvent releaseEvent = this.getReleaseEvent();
        releaseEvent.getProperties().add((Property)new Uid(this.id));
        this.calendar.getComponents().add((Object)releaseEvent);
    }

    private Calendar getCalendar() {
        Calendar calendar = new Calendar();
        calendar.getProperties().add((Property)new ProdId("-//Digital.ai Release//iCal4j 1.0//EN"));
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        return calendar;
    }

    private VEvent getReleaseEvent() {
        VEvent releaseEvent;
        org.joda.time.DateTime startDate = new org.joda.time.DateTime((Object)this.scheduledStartDate);
        org.joda.time.DateTime endDate = new org.joda.time.DateTime((Object)this.dueDate);
        int durationInDays = Days.daysBetween((ReadableInstant)startDate.withTimeAtStartOfDay(), (ReadableInstant)endDate.withTimeAtStartOfDay()).getDays();
        if (durationInDays < 2) {
            releaseEvent = new VEvent((net.fortuna.ical4j.model.Date)new DateTime(this.scheduledStartDate), (net.fortuna.ical4j.model.Date)new DateTime(this.dueDate), this.title);
        } else {
            endDate = endDate.plusDays(1);
            releaseEvent = new VEvent(new net.fortuna.ical4j.model.Date(this.scheduledStartDate), new net.fortuna.ical4j.model.Date(endDate.toDate()), this.title);
        }
        releaseEvent.getProperties().add((Property)new Description(this.description));
        return releaseEvent;
    }

    public String toString() {
        return this.calendar.toString();
    }
}

