/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.api.v1.forms.TenantLinkRequest;
import com.xebialabs.xlrelease.api.v1.forms.TenantResourceLinkOperation;
import com.xebialabs.xlrelease.domain.Tenant;
import com.xebialabs.xlrelease.domain.events.FolderTenantLinkEvent;
import com.xebialabs.xlrelease.domain.events.TenantCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TenantDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TenantUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.UserProfileTenantLinkEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TenantStatus;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TenantRepository;
import java.io.Serializable;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001B\u0006\r\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tG\u0001\u0011\t\u0011)A\u0005I!)!\u0006\u0001C\u0001W!)\u0001\u0007\u0001C\u0001c!)A\t\u0001C\u0001\u000b\")\u0001\u000b\u0001C\u0001#\")A\u000b\u0001C\u0001+\")\u0001\r\u0001C\u0001C\")q\r\u0001C\u0001Q\")!\u000e\u0001C\u0001W\niA+\u001a8b]R\u001cVM\u001d<jG\u0016T!!\u0004\b\u0002\u000fM,'O^5dK*\u0011q\u0002E\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0005\n\u0002\u0013a,'-[1mC\n\u001c(\"A\n\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g-\u0001\tuK:\fg\u000e\u001e*fa>\u001c\u0018\u000e^8ssB\u0011a$I\u0007\u0002?)\u0011\u0001ED\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\u0012 \u0005A!VM\\1oiJ+\u0007o\\:ji>\u0014\u00180\u0001\u0005fm\u0016tGOQ;t!\t)\u0003&D\u0001'\u0015\t9c\"\u0001\u0004fm\u0016tGo]\u0005\u0003S\u0019\u0012\u0001\"\u0012<f]R\u0014Uo]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071rs\u0006\u0005\u0002.\u00015\tA\u0002C\u0003\u001d\u0007\u0001\u0007Q\u0004C\u0003$\u0007\u0001\u0007A%A\u0007hKR\fE\u000e\u001c+f]\u0006tGo\u001d\u000b\u0002eA\u00191g\u000f \u000f\u0005QJdBA\u001b9\u001b\u00051$BA\u001c\u0015\u0003\u0019a$o\\8u}%\t\u0011$\u0003\u0002;1\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001f>\u0005\u0011a\u0015n\u001d;\u000b\u0005iB\u0002CA C\u001b\u0005\u0001%BA!\u000f\u0003\u0019!w.\\1j]&\u00111\t\u0011\u0002\u0007)\u0016t\u0017M\u001c;\u0002\u001d\u0019Lg\u000e\u001a+f]\u0006tGOQ=JIR\u0011aH\u0012\u0005\u0006\u000f\u0016\u0001\r\u0001S\u0001\ti\u0016t\u0017M\u001c;JIB\u0011\u0011*\u0014\b\u0003\u0015.\u0003\"!\u000e\r\n\u00051C\u0012A\u0002)sK\u0012,g-\u0003\u0002O\u001f\n11\u000b\u001e:j]\u001eT!\u0001\u0014\r\u0002!\u0019Lg\u000e\u001a+f]\u0006tGOQ=OC6,GC\u0001 S\u0011\u0015\u0019f\u00011\u0001I\u0003\u0011q\u0017-\\3\u0002\u0019\r\u0014X-\u0019;f)\u0016t\u0017M\u001c;\u0015\u0007y2\u0006\fC\u0003X\u000f\u0001\u0007\u0001*\u0001\u0006uK:\fg\u000e\u001e(b[\u0016DQ!W\u0004A\u0002i\u000bA\u0002^3oC:$8\u000b^1ukN\u0004\"a\u00170\u000e\u0003qS!!\u0018!\u0002\rM$\u0018\r^;t\u0013\tyFL\u0001\u0007UK:\fg\u000e^*uCR,8/\u0001\u0007va\u0012\fG/\u001a+f]\u0006tG\u000f\u0006\u0002cKB\u0011qcY\u0005\u0003Ib\u0011A!\u00168ji\")a\r\u0003a\u0001}\u00051A/\u001a8b]R\fA\u0002Z3mKR,G+\u001a8b]R$\"AY5\t\u000b\u001dK\u0001\u0019\u0001%\u0002\u00191Lgn\u001b*fg>,(oY3\u0015\u0007\tdW\u000eC\u0003H\u0015\u0001\u0007\u0001\nC\u0003o\u0015\u0001\u0007q.\u0001\u0007mS:\\'+Z9vKN$8\u000fE\u0002qkZl\u0011!\u001d\u0006\u0003eN\fA!\u001e;jY*\tA/\u0001\u0003kCZ\f\u0017B\u0001\u001fr!\t9h0D\u0001y\u0015\tI(0A\u0003g_Jl7O\u0003\u0002|y\u0006\u0011a/\r\u0006\u0003{:\t1!\u00199j\u0013\ty\bPA\tUK:\fg\u000e\u001e'j].\u0014V-];fgRD3\u0001AA\u0002!\u0011\t)!a\u0005\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\t!b\u001d;fe\u0016|G/\u001f9f\u0015\u0011\ti!a\u0004\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!!\u0005\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0016\u0005\u001d!aB*feZL7-\u001a")
public class TenantService {
    private final TenantRepository tenantRepository;
    private final EventBus eventBus;

    public List<Tenant> getAllTenants() {
        return this.tenantRepository.findAll().toList();
    }

    public Tenant findTenantById(String tenantId) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)tenantId), (String)"Tenant ID cannot be empty", (Object[])new Object[0]);
        return (Tenant)this.tenantRepository.findById(tenantId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("No tenant found with ID '" + tenantId + "'", new Object[0]);
        });
    }

    public Tenant findTenantByName(String name) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)name), (String)"Tenant name cannot be empty", (Object[])new Object[0]);
        return (Tenant)this.tenantRepository.findByName(name.toLowerCase().trim()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("No tenant found with name '" + name + "'", new Object[0]);
        });
    }

    public Tenant createTenant(String tenantName, TenantStatus tenantStatus) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)tenantName), (String)"Tenant name cannot be empty", (Object[])new Object[0]);
        Checks.checkArgument((tenantStatus != null ? 1 : 0) != 0, (String)"Tenant status cannot be null", (Object[])new Object[0]);
        String normalizedTenantName = tenantName.toLowerCase().trim();
        Tenant createdTenant = this.tenantRepository.create(normalizedTenantName, tenantStatus);
        this.eventBus.publish((XLReleaseEvent)new TenantCreatedEvent(createdTenant));
        return createdTenant;
    }

    public void updateTenant(Tenant tenant) {
        Checks.checkArgument((tenant != null ? 1 : 0) != 0, (String)"Tenant cannot be null", (Object[])new Object[0]);
        Checks.checkArgument((boolean)StringUtils.hasText((String)tenant.tenantName()), (String)"Tenant name cannot be empty", (Object[])new Object[0]);
        Checks.checkArgument((tenant.tenantStatus() != null ? 1 : 0) != 0, (String)"Tenant status cannot be null", (Object[])new Object[0]);
        Tenant original = this.findTenantById(tenant.tenantId());
        this.tenantRepository.update(tenant);
        this.eventBus.publish((XLReleaseEvent)new TenantUpdatedEvent(original, tenant));
    }

    public void deleteTenant(String tenantId) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)tenantId), (String)"Tenant ID cannot be empty", (Object[])new Object[0]);
        Tenant tenant = this.findTenantById(tenantId);
        this.tenantRepository.delete(tenantId);
        this.eventBus.publish((XLReleaseEvent)new TenantDeletedEvent(tenant));
    }

    public void linkResource(String tenantId, java.util.List<TenantLinkRequest> linkRequests) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)tenantId), (String)"Tenant ID cannot be empty", (Object[])new Object[0]);
        Checks.checkArgument((linkRequests != null ? 1 : 0) != 0, (String)"Link requests cannot be null", (Object[])new Object[0]);
        this.findTenantById(tenantId);
        CollectionConverters$.MODULE$.ListHasAsScala(linkRequests).asScala().toList().groupBy((Function1 & Serializable)x$1 -> x$1.getLinkOperation()).foreach((Function1 & Serializable)x0$1 -> {
            TenantService.$anonfun$linkResource$2(this, tenantId, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$linkResource$4(String str) {
        return StringUtils.hasText((String)str);
    }

    public static final /* synthetic */ boolean $anonfun$linkResource$5(String id) {
        return Ids.isFolderId((String)id);
    }

    public static final /* synthetic */ boolean $anonfun$linkResource$9(String str) {
        return StringUtils.hasText((String)str);
    }

    public static final /* synthetic */ void $anonfun$linkResource$2(TenantService $this, String tenantId$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TenantResourceLinkOperation tenantResourceLinkOperation = (TenantResourceLinkOperation)tuple2._1();
            List folderRequests = (List)tuple2._2();
            if (TenantResourceLinkOperation.FOLDER.equals(tenantResourceLinkOperation)) {
                List folderIds = folderRequests.map((Function1 & Serializable)x$2 -> x$2.getTargetId()).filter((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)TenantService.$anonfun$linkResource$4(str))).filter((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)TenantService.$anonfun$linkResource$5(id))).map((Function1 & Serializable)id -> Ids.getName((String)id)).map((Function1 & Serializable)id -> Ids.normalizeId((String)id));
                if (folderIds.nonEmpty()) {
                    $this.tenantRepository.linkFoldersToTenant(tenantId$2, (List<String>)folderIds);
                    $this.eventBus.publish((XLReleaseEvent)new FolderTenantLinkEvent(tenantId$2, (Seq)folderIds));
                    return;
                }
                return;
            }
        }
        if (tuple2 != null) {
            TenantResourceLinkOperation tenantResourceLinkOperation = (TenantResourceLinkOperation)tuple2._1();
            List userProfileRequests = (List)tuple2._2();
            if (TenantResourceLinkOperation.USER_PROFILE.equals(tenantResourceLinkOperation)) {
                List userProfileIds = userProfileRequests.map((Function1 & Serializable)x$3 -> x$3.getTargetId()).filter((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)TenantService.$anonfun$linkResource$9(str))).map((Function1 & Serializable)x$4 -> x$4.toLowerCase());
                if (userProfileIds.nonEmpty()) {
                    $this.tenantRepository.linkUserProfilesToTenant(tenantId$2, (List<String>)userProfileIds);
                    $this.eventBus.publish((XLReleaseEvent)new UserProfileTenantLinkEvent(tenantId$2, (Seq)userProfileIds));
                    return;
                }
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public TenantService(TenantRepository tenantRepository, EventBus eventBus) {
        this.tenantRepository = tenantRepository;
        this.eventBus = eventBus;
    }
}

