/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.script;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.converters.BaseTaskViewConverter;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ScriptTaskViewConverter
extends BaseTaskViewConverter<ScriptTask> {
    @Override
    public TaskFullView toFullView(ScriptTask task, List<Type> allowedTaskTypesForAuthenticatedUser) {
        TaskFullView v = super.toFullView(task, allowedTaskTypesForAuthenticatedUser);
        v.setScript(task.getScript());
        v.setIgnoreScriptVariableInterpolation(task.isScriptInterpolationOff());
        v.setScriptTimeout(task.getScriptTimeout());
        return v;
    }

    @Override
    public ScriptTask toTask(TaskFullView view) {
        ScriptTask scriptTask = (ScriptTask)super.toTask(view);
        scriptTask.setIgnoreScriptVariableInterpolation(view.isIgnoreScriptVariableInterpolation());
        scriptTask.setScriptTimeout(view.getScriptTimeout());
        return scriptTask;
    }

    @Override
    protected ScriptTask fromView(TaskFullView view) {
        return TaskBuilder.newScriptTask().withScript(view.getScript()).build();
    }

    @Override
    protected Class<ScriptTask> getTaskClass() {
        return ScriptTask.class;
    }
}

