/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskGranularPermissions {
    private PermissionChecker permissionChecker;
    private ReleaseRepository releaseRepository;
    private final Map<Permission, TaskUpdateDirective> permissionToUpdateDirective = Stream.of({XLReleasePermissions.EDIT_RELEASE_TASK, TaskUpdateDirective.UPDATE_RELEASE_TASK}, {XLReleasePermissions.EDIT_TEMPLATE, TaskUpdateDirective.UPDATE_TEMPLATE_TASK}, {XLReleasePermissions.EDIT_RELEASE_TASK_CONFIGURATION, TaskUpdateDirective.UPDATE_TASK_CONFIGURATION}, {XLReleasePermissions.EDIT_TASK_TAGS, TaskUpdateDirective.UPDATE_TASK_TAGS}, {XLReleasePermissions.EDIT_RELEASE_TASK_SCRIPT, TaskUpdateDirective.UPDATE_TASK_SCRIPT}, {XLReleasePermissions.EDIT_TASK_DATES, TaskUpdateDirective.UPDATE_TASK_DATES}, {XLReleasePermissions.EDIT_TASK_FLAG, TaskUpdateDirective.UPDATE_TASK_FLAG}, {XLReleasePermissions.EDIT_TASK_DESCRIPTION, TaskUpdateDirective.UPDATE_TASK_DESCRIPTION_AND_TITLE}, {XLReleasePermissions.EDIT_RELEASE_FAILURE_HANDLER, TaskUpdateDirective.UPDATE_TASK_FAILURE_HANDLER}, {XLReleasePermissions.EDIT_RELEASE_PRECONDITION, TaskUpdateDirective.UPDATE_TASK_PRECONDITION}, {XLReleasePermissions.EDIT_TEMPLATE_FAILURE_HANDLER, TaskUpdateDirective.UPDATE_TEMPLATE_TASK_FAILURE_HANDLER}, {XLReleasePermissions.EDIT_TEMPLATE_PRECONDITION, TaskUpdateDirective.UPDATE_TEMPLATE_TASK_PRECONDITION}, {XLReleasePermissions.EDIT_BLACKOUT, TaskUpdateDirective.UPDATE_TASK_BLACKOUT_POSTPONE}).collect(Collectors.toMap(data -> (Permission)data[0], data -> (TaskUpdateDirective)((Object)((Object)data[1]))));
    private final Set<Permission> allTaskGranularPermissions = this.permissionToUpdateDirective.keySet();

    @Autowired
    public TaskGranularPermissions(PermissionChecker permissionChecker, ReleaseRepository releaseRepository) {
        this.permissionChecker = permissionChecker;
        this.releaseRepository = releaseRepository;
    }

    public boolean hasEditTaskConfigurationGranularPermission(String releaseId) {
        return this.getUpdateDirectives(releaseId).contains((Object)TaskUpdateDirective.UPDATE_TASK_CONFIGURATION);
    }

    public Set<TaskUpdateDirective> getUpdateDirectives(String releaseId) {
        Set<TaskUpdateDirective> directives = this.allTaskGranularPermissions.stream().filter(permission -> this.permissionChecker.hasPermission((Permission)permission, releaseId)).map(this.permissionToUpdateDirective::get).collect(Collectors.toSet());
        if (directives.isEmpty()) {
            throw PermissionDeniedException.withMessage((String)"You are not allowed to edit tasks of this release.");
        }
        return directives;
    }

    public boolean hasDirectiveToUpdateAllProperties(String releaseId) {
        return this.hasDirectiveToUpdateAllProperties(releaseId, this.getUpdateDirectives(releaseId));
    }

    public boolean hasDirectiveToUpdateAllProperties(String releaseId, Set<TaskUpdateDirective> directives) {
        boolean isTemplate = this.releaseRepository.isTemplate(releaseId);
        boolean isDefinedAndNotEmpty = directives != null && !directives.isEmpty();
        return isDefinedAndNotEmpty && (isTemplate && directives.contains((Object)TaskUpdateDirective.UPDATE_TEMPLATE_TASK) || !isTemplate && directives.contains((Object)TaskUpdateDirective.UPDATE_RELEASE_TASK));
    }

    public void checkHasEditTaskOrEditTaskConfiguration(String releaseId) {
        Permission permission;
        boolean isTemplate = this.releaseRepository.isTemplate(releaseId);
        Permission permission2 = permission = isTemplate ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE_TASK;
        if (!this.permissionChecker.hasPermission(permission, releaseId) && !this.hasEditTaskConfigurationGranularPermission(releaseId)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)releaseId);
        }
    }
}

