/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.repository.ItemConflictException;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.Variable;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.DateVariable;
import com.xebialabs.xlrelease.domain.variables.ValueProvider;
import com.xebialabs.xlrelease.domain.variables.ValueProviderConfiguration;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.service.ExternalVariableService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.VariableService;
import com.xebialabs.xlrelease.utils.DateVariableUtils;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VariableComponent {
    private final PermissionChecker permissions;
    private final ReleaseService releaseService;
    private final VariableService variableService;
    private final ReleaseActorService releaseActorService;
    private ExternalVariableService externalVariableService;
    private Map<Class<? extends ValueProviderConfiguration>, ValueProvider> valueProvidersPerType = new HashMap<Class<? extends ValueProviderConfiguration>, ValueProvider>();

    @Autowired
    public VariableComponent(PermissionChecker permissions, ReleaseService releaseService, VariableService variableService, ReleaseActorService releaseActorService, ExternalVariableService externalVariableService) {
        this.permissions = permissions;
        this.releaseService = releaseService;
        this.variableService = variableService;
        this.releaseActorService = releaseActorService;
        this.externalVariableService = externalVariableService;
    }

    @Autowired
    public void setValueProviders(List<? extends ValueProvider<?, ? extends ValueProviderConfiguration>> valueProviders) {
        valueProviders.forEach(valueProvider -> this.valueProvidersPerType.put(valueProvider.getValueProviderConfigurationClass(), (ValueProvider)valueProvider));
    }

    public List<com.xebialabs.xlrelease.domain.variables.Variable> getVariables(String containerId) {
        Release release = this.releaseService.findByIdIncludingArchived(containerId, ResolveOptions.WITHOUT_DECORATORS().withReferences());
        this.permissions.checkView(release);
        return release.getVariables();
    }

    public com.xebialabs.xlrelease.domain.variables.Variable getVariable(String variableId) {
        this.permissions.checkView(Ids.releaseIdFrom((String)variableId));
        String releaseId = Ids.releaseIdFrom((String)variableId);
        String parentId = Ids.getParentId((String)variableId);
        if (releaseId.equals(parentId)) {
            return this.variableService.findByIdIncludingArchived(variableId);
        }
        if (Ids.isTaskId((String)parentId)) {
            Release release = this.releaseService.findByIdIncludingArchived(releaseId, ResolveOptions.WITHOUT_DECORATORS());
            Task task = release.getTask(parentId);
            if (task instanceof CreateReleaseTask) {
                return ((CreateReleaseTask)task).getTemplateVariables().stream().filter(variable -> variable.getId().equals(variableId)).findFirst().orElseThrow(() -> new LogFriendlyNotFoundException("Variable '%s' does not exist in the repository or archive", new Object[]{variableId}));
            }
            throw new IllegalArgumentException(String.format("Variable '%s' is not a create release task template variable", variableId));
        }
        throw new IllegalArgumentException(String.format("Variable '%s' is neither a release variable nor a create release task template variable", variableId));
    }

    public Collection<Object> getVariablePossibleValues(String variableId) {
        return this.getVariablePossibleValues(this.getVariable(variableId));
    }

    public Collection<Object> getVariablePossibleValues(com.xebialabs.xlrelease.domain.variables.Variable variable) {
        Collection<Object> values = Collections.emptyList();
        ValueProviderConfiguration valueProviderConfiguration = variable.getValueProvider();
        if (valueProviderConfiguration != null) {
            ValueProvider valueProvider = this.valueProvidersPerType.get(valueProviderConfiguration.getClass());
            values = valueProvider.possibleValues(valueProviderConfiguration);
        }
        return values;
    }

    public boolean isVariableUsed(String variableId) {
        String releaseId = Ids.releaseIdFrom((String)variableId);
        Release release = this.releaseService.findById(releaseId, ResolveOptions.WITHOUT_DECORATORS());
        Optional variable = release.getVariableById(Ids.normalizeId((String)variableId));
        if (variable.isEmpty()) {
            throw new NotFoundException("Repository entity [%s] not found", new Object[]{variableId});
        }
        return release.isVariableUsed((com.xebialabs.xlrelease.domain.variables.Variable)variable.get());
    }

    private com.xebialabs.xlrelease.domain.variables.Variable getVariableFromRelease(Release release, String variableId) {
        return (com.xebialabs.xlrelease.domain.variables.Variable)release.getVariableById(Ids.normalizeId((String)variableId)).orElseThrow(() -> new NotFoundException("Repository entity [%s] not found", new Object[]{variableId}));
    }

    public void replaceVariable(String variableId, VariableOrValue replacement) {
        Checks.checkNotNull((Object)replacement, (String)"Variable replacement must be defined");
        String releaseId = Ids.releaseIdFrom((String)variableId);
        Release release = this.releaseService.findById(releaseId, ResolveOptions.WITHOUT_DECORATORS());
        com.xebialabs.xlrelease.domain.variables.Variable variable = this.getVariableFromRelease(release, variableId);
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Cannot replace variable in release '%s' because it is %s.", (Object)release.getTitle(), (Object)release.getStatus());
        this.permissions.checkEditVariable(release, variable);
        this.convertValueToAppropriateType(variable, replacement);
        this.assertReplacementPreconditions(release, variable, replacement);
        this.releaseActorService.replaceVariable(variable, replacement);
    }

    private void assertReplacementPreconditions(Release release, com.xebialabs.xlrelease.domain.variables.Variable variable, VariableOrValue replacement) {
        if (!Strings.isNullOrEmpty((String)replacement.getVariable())) {
            Preconditions.checkArgument((boolean)VariableHelper.containsOnlyVariable((String)replacement.getVariable()), (String)"Variable '%s' in release '%s' can be replaced by only one other variable.", (Object)variable.getKey(), (Object)release.getTitle());
            Set replacementVariableKeys = VariableHelper.collectVariables((Object)replacement.getVariable());
            String replacementVariableKey = VariableHelper.withoutVariableSyntax((String)((String)replacementVariableKeys.iterator().next()));
            Preconditions.checkArgument((!replacementVariableKey.equals(variable.getKey()) ? 1 : 0) != 0, (String)"Variable '%s' in release '%s' cannot be replaced by itself.", (Object)variable.getKey(), (Object)release.getTitle());
            Map existingVariableMap = release.getVariablesByKeys();
            com.xebialabs.xlrelease.domain.variables.Variable existingVariable = (com.xebialabs.xlrelease.domain.variables.Variable)existingVariableMap.get(replacementVariableKey);
            if (null != existingVariable) {
                Preconditions.checkArgument((boolean)variable.getType().equals((Object)existingVariable.getType()), (String)"Cannot replace variable '%s' of type '%s' in release '%s' with an existing variable '%s' of type '%s'. Types must match.", (Object[])new Object[]{variable.getKey(), variable.getType(), release.getTitle(), existingVariable.getKey(), existingVariable.getType()});
            }
        } else if (null != replacement.getValue()) {
            Preconditions.checkArgument((boolean)variable.isValueAssignableFrom(replacement.getValue()), (String)"Variable '%s' in release '%s' cannot be replaced by an incompatible value of type '%s'.", (Object)variable.getKey(), (Object)release.getTitle(), (Object)replacement.getValue().getClass().getName());
        }
    }

    public void deleteVariable(String variableId) {
        String releaseId = Ids.releaseIdFrom((String)variableId);
        Release release = this.releaseService.findById(releaseId, ResolveOptions.WITHOUT_DECORATORS());
        com.xebialabs.xlrelease.domain.variables.Variable variable = this.getVariableFromRelease(release, variableId);
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't delete variable from release '%s' because it is %s", (Object)release.getTitle(), (Object)release.getStatus());
        this.permissions.checkEditVariable(release, variable);
        Preconditions.checkArgument((!this.isVariableUsed(variableId) ? 1 : 0) != 0, (Object)String.format("Variable '%s' is still used. Replace it before you try to delete it.", variable.getKey()));
        this.releaseActorService.deleteVariable(variableId);
    }

    public com.xebialabs.xlrelease.domain.variables.Variable createVariable(String containerId, Variable variable) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)variable.getKey()) ? 1 : 0) != 0, (String)"Variable must have a 'key' field", (Object[])new Object[0]);
        Checks.checkArgument((variable.getId() == null ? 1 : 0) != 0, (String)"Variable that is about to be created can not have 'id' set", (Object[])new Object[0]);
        this.permissions.checkEdit(containerId);
        this.externalVariableService.checkExistsAndCorrectType(variable.getExternalVariableValue());
        return this.releaseActorService.createVariable(variable.toReleaseVariable(), containerId);
    }

    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(String oldVariableId, com.xebialabs.xlrelease.domain.variables.Variable newVariable) {
        com.xebialabs.xlrelease.domain.variables.Variable var;
        VariableHelper.checkVariableIdsAreTheSame((String)oldVariableId, (String)newVariable.getId());
        if (VariableHelper.isGlobalVariableId((String)newVariable.getId())) {
            throw new ItemConflictException("Variable id [%s] doesn't belong to the release variable", new Object[]{newVariable.getId()});
        }
        String releaseId = Ids.releaseIdFrom((String)newVariable.getId());
        Release release = this.releaseService.findById(releaseId, ResolveOptions.WITHOUT_DECORATORS());
        com.xebialabs.xlrelease.domain.variables.Variable oldVariable = this.getVariableFromRelease(release, newVariable.getId());
        this.permissions.checkEditVariable(release, newVariable);
        if (oldVariable.getKey().equals(newVariable.getKey())) {
            var = this.releaseActorService.updateVariable(newVariable.getId(), newVariable);
        } else {
            Checks.checkArgument((boolean)oldVariable.getType().equals((Object)newVariable.getType()), (String)"Variable id [%s] of type [%s] cannot be renamed to a variable [%s] of type [%s].", (Object[])new Object[]{oldVariable.getKey(), oldVariable.getType(), newVariable.getKey(), newVariable.getType()});
            var = this.releaseActorService.renameVariable(oldVariableId, newVariable);
        }
        return var;
    }

    public List<com.xebialabs.xlrelease.domain.variables.Variable> updateVariables(String releaseId, List<com.xebialabs.xlrelease.domain.variables.Variable> variables) {
        VariableHelper.checkVariables(variables);
        this.permissions.checkEdit(releaseId);
        Release updatedRelease = this.releaseActorService.updateVariables(releaseId, variables);
        return updatedRelease.getVariables();
    }

    private void convertValueToAppropriateType(com.xebialabs.xlrelease.domain.variables.Variable variable, VariableOrValue replacement) {
        if (variable instanceof DateVariable && replacement.getValue() != null) {
            if (replacement.getValue() instanceof String) {
                replacement.setValue((Object)DateVariableUtils.parseDate((String)((String)replacement.getValue())));
            } else if (replacement.getValue() instanceof Long) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis((Long)replacement.getValue());
                replacement.setValue((Object)calendar.getTime());
            }
        }
    }
}

