/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.userinput;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import com.xebialabs.xlrelease.domain.tasks.task.DefaultTaskUpdater;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.ReleaseVariableUpdateOperation;
import com.xebialabs.xlrelease.events.XLReleaseOperation;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class UserInputTaskUpdater
extends DefaultTaskUpdater {
    @Override
    public Class<? extends Task> getTaskClass() {
        return UserInputTask.class;
    }

    @Override
    public Changes update(Task original, Task updated, Set<TaskUpdateDirective> updateDirectives) {
        Changes changes = super.update(original, updated, updateDirectives);
        boolean taskUpdated = false;
        if (this.hasDirectiveToUpdateAllProperties(original, updateDirectives) || updateDirectives.contains((Object)TaskUpdateDirective.UPDATE_TASK_CONFIGURATION)) {
            changes.update((ConfigurationItem)original);
            this.updateVariablesConfiguration((UserInputTask)original, (UserInputTask)updated);
            taskUpdated = true;
        }
        if (updateDirectives.contains((Object)TaskUpdateDirective.UPDATE_USER_INPUT_TASK_VARIABLES_VALUES)) {
            Release release = original.getRelease();
            List updatedVariables = ((UserInputTask)updated).getVariables();
            Map variablesByKeys = release.getVariablesByKeys();
            for (Variable updatedVariable : updatedVariables) {
                Variable variable = (Variable)variablesByKeys.get(updatedVariable.getKey());
                if (variable == null || this.isPasswordMasked(updatedVariable)) continue;
                if (!Objects.equals(variable.getValue(), updatedVariable.getValue())) {
                    Variable originalVariable = CiCloneHelper.cloneCi(variable);
                    variable.setUntypedValue(updatedVariable.getValue());
                    changes.addOperation((XLReleaseOperation)new ReleaseVariableUpdateOperation(originalVariable, variable));
                }
                taskUpdated = true;
            }
        }
        if (taskUpdated) {
            this.taskConcurrencyService.updateLastModifiedDetails(original);
        }
        return changes;
    }

    private boolean isPasswordMasked(Variable updatedVariable) {
        return updatedVariable.isPassword() && PasswordVerificationUtils.isMaskedPassword(updatedVariable.getValueAsString());
    }

    private void updateVariablesConfiguration(UserInputTask original, UserInputTask updated) {
        List releaseVariables = original.getRelease().getVariables();
        original.setVariables(updated.getVariables().stream().filter(releaseVariables::contains).collect(Collectors.toList()));
    }
}

