/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.configuration.ArchivingSettings;
import com.xebialabs.xlrelease.configuration.AuditReportSettings;
import com.xebialabs.xlrelease.configuration.CustomLogoSettings;
import com.xebialabs.xlrelease.configuration.ExecutionLogPurgeSettings;
import com.xebialabs.xlrelease.configuration.FeatureSettings;
import com.xebialabs.xlrelease.configuration.PollingSettings;
import com.xebialabs.xlrelease.configuration.ReportsSettings;
import com.xebialabs.xlrelease.configuration.ThemeColor;
import com.xebialabs.xlrelease.configuration.ThemeColors$;
import com.xebialabs.xlrelease.configuration.ThemeSettings;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.BaseSettings;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001B\t\u0013\u0001mA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!)\u0001\b\u0001C\u0001s!)a\b\u0001C\u0001\u007f!)a\b\u0001C\u0001E\")\u0011\u000e\u0001C\u0001U\")A\u000e\u0001C\u0001[\")1\u000f\u0001C\u0001i\")q\u000f\u0001C\u0001q\"1q\u0010\u0001C\u0005\u0003\u0003Aq!a\u0002\u0001\t\u0003\tI\u0001C\u0004\u0002\u0018\u0001!\t!!\u0007\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u0011q\u0003\u0001\u0005\u0002\u0005\u0005\u0003bBA%\u0001\u0011\u0005\u00111\n\u0005\b\u0003'\u0002A\u0011AA+\u0005Q\u0019uN\u001c4jOV\u0014\u0018\r^5p]N+'O^5dK*\u00111\u0003F\u0001\bg\u0016\u0014h/[2f\u0015\t)b#A\u0005yYJ,G.Z1tK*\u0011q\u0003G\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!G\u0001\u0004G>l7\u0001A\n\u0004\u0001q\u0011\u0003CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g\r\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005)1\u000f\u001c45U*\tq%\u0001\u0005he&T(\u0010\\3e\u0013\tICEA\u0004M_\u001e<\u0017N\\4\u0002/\r|gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\bC\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0015\u0003)\u0011X\r]8tSR|'/_\u0005\u0003a5\u0012qcQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0002\u0011\u00154XM\u001c;CkN\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\u000b\u0002\r\u00154XM\u001c;t\u0013\t9DGA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkN\fa\u0001P5oSRtDc\u0001\u001e={A\u00111\bA\u0007\u0002%!)!f\u0001a\u0001W!)\u0011g\u0001a\u0001e\u0005q1M]3bi\u0016|%/\u00169eCR,Gc\u0001!G'B\u0011\u0011\tR\u0007\u0002\u0005*\u00111\tF\u0001\u0007I>l\u0017-\u001b8\n\u0005\u0015\u0013%!\u0005\"bg\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\")q\t\u0002a\u0001\u0011\u0006\u0011\u0011\u000e\u001a\t\u0003\u0013Bs!A\u0013(\u0011\u0005-sR\"\u0001'\u000b\u00055S\u0012A\u0002\u001fs_>$h(\u0003\u0002P=\u00051\u0001K]3eK\u001aL!!\u0015*\u0003\rM#(/\u001b8h\u0015\tye\u0004C\u0003U\t\u0001\u0007\u0001)A\td_:4\u0017nZ;sCRLwN\\%uK6D#\u0001\u0002,\u0011\u0005]\u0003W\"\u0001-\u000b\u0005eS\u0016AC1o]>$\u0018\r^5p]*\u00111\fX\u0001\u0005G>\u0014XM\u0003\u0002^=\u0006QQ.[2s_6,G/\u001a:\u000b\u0003}\u000b!![8\n\u0005\u0005D&!\u0002+j[\u0016$GCA2g!\tiB-\u0003\u0002f=\t!QK\\5u\u0011\u00159W\u00011\u0001A\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]\"\u0012QAV\u0001\u0005e\u0016\fG\r\u0006\u0002AW\")qI\u0002a\u0001\u0011\u00061Q\r_5tiN$\"A\\9\u0011\u0005uy\u0017B\u00019\u001f\u0005\u001d\u0011un\u001c7fC:DQaR\u0004A\u0002!C#a\u0002,\u0002\r\u0011,G.\u001a;f)\t\u0019W\u000fC\u0003H\u0011\u0001\u0007\u0001\n\u000b\u0002\t-\u0006\u0001r-\u001a;UQ\u0016lWmU3ui&twm]\u000b\u0002sB\u0011!\u0010`\u0007\u0002w*\u0011q\rF\u0005\u0003{n\u0014Q\u0002\u00165f[\u0016\u001cV\r\u001e;j]\u001e\u001c\bFA\u0005W\u0003Y\u0019wN\u001c<feR\u001cu\u000e\\8s\u001d\u0006lW\rV8D_\u0012,GcA=\u0002\u0004!1\u0011Q\u0001\u0006A\u0002e\fQ\u0002\u001e5f[\u0016\u001cV\r\u001e;j]\u001e\u001c\u0018AD:bm\u0016\u001cUo\u001d;p[2{wm\u001c\u000b\u0005\u0003\u0017\t\t\u0002E\u0002{\u0003\u001bI1!a\u0004|\u0005I\u0019Uo\u001d;p[2{wm\\*fiRLgnZ:\t\u000f\u0005M1\u00021\u0001\u0002\f\u0005\u00112-^:u_6dunZ8TKR$\u0018N\\4tQ\tYa+\u0001\nhKR4U-\u0019;ve\u0016\u001cV\r\u001e;j]\u001e\u001cHCAA\u000e!\u0019\ti\"a\n\u0002,5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#\u0001\u0003vi&d'BAA\u0013\u0003\u0011Q\u0017M^1\n\t\u0005%\u0012q\u0004\u0002\u0005\u0019&\u001cH\u000fE\u0002{\u0003[I1!a\f|\u0005=1U-\u0019;ve\u0016\u001cV\r\u001e;j]\u001e\u001c\bF\u0001\u0007W\u0003E9W\r^*zgR,WnU3ui&twm\u001d\u000b\u0003\u0003o\u0001b!!\b\u0002(\u0005e\u0002cA!\u0002<%\u0019\u0011Q\b\"\u0003\u0019\t\u000b7/Z*fiRLgnZ:)\u000551F\u0003BA\u0016\u0003\u0007Ba!!\u0012\u000f\u0001\u0004A\u0015a\u00034fCR,(/\u001a+za\u0016D#A\u0004,\u0002'M\fg/\u001a$fCR,(/Z*fiRLgnZ:\u0015\u0007\r\fi\u0005C\u0004\u0002P=\u0001\r!a\u0007\u0002\u0011\u0019,\u0017\r^;sKND#a\u0004,\u0002\u0019M\fg/Z*fiRLgnZ:\u0015\u0007\r\f9\u0006C\u0004\u0002ZA\u0001\r!a\u000e\u0002\u0011M,G\u000f^5oOND#\u0001\u0005,)\u0007\u0001\ty\u0006\u0005\u0003\u0002b\u0005=TBAA2\u0015\u0011\t)'a\u001a\u0002\u0015M$XM]3pif\u0004XM\u0003\u0003\u0002j\u0005-\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u00055\u0014aA8sO&!\u0011\u0011OA2\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class ConfigurationService
implements Logging {
    private final ConfigurationRepository configurationRepository;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ConfigurationService configurationService = this;
        synchronized (configurationService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public BaseConfiguration createOrUpdate(String id, BaseConfiguration configurationItem) {
        BaseConfiguration baseConfiguration = configurationItem;
        if (baseConfiguration instanceof ReportsSettings) {
            ReportsSettings reportsSettings = (ReportsSettings)baseConfiguration;
            reportsSettings.validate();
        } else if (baseConfiguration instanceof ArchivingSettings) {
            ArchivingSettings archivingSettings = (ArchivingSettings)baseConfiguration;
            archivingSettings.validate();
        } else if (baseConfiguration instanceof PollingSettings) {
            PollingSettings pollingSettings = (PollingSettings)baseConfiguration;
            pollingSettings.validate();
        } else if (baseConfiguration instanceof AuditReportSettings) {
            AuditReportSettings auditReportSettings = (AuditReportSettings)baseConfiguration;
            auditReportSettings.validate();
        } else if (baseConfiguration instanceof ExecutionLogPurgeSettings) {
            ExecutionLogPurgeSettings executionLogPurgeSettings = (ExecutionLogPurgeSettings)baseConfiguration;
            executionLogPurgeSettings.validate();
        } else if (baseConfiguration instanceof CustomLogoSettings) {
            CustomLogoSettings customLogoSettings = (CustomLogoSettings)baseConfiguration;
            customLogoSettings.validateContentType();
        }
        configurationItem.setId(id);
        this.createOrUpdate(configurationItem);
        return this.read(id);
    }

    @Timed
    public void createOrUpdate(BaseConfiguration configuration) {
        if (!Ids.isNullId((String)configuration.getId()) && this.configurationRepository.exists(configuration.getId())) {
            Object original = this.configurationRepository.read(configuration.getId());
            PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)new Some(original), (ConfigurationItem)configuration);
            this.configurationRepository.update(configuration);
            this.eventBus.publish((XLReleaseEvent)new ConfigurationUpdatedEvent(configuration));
            return;
        }
        this.configurationRepository.create(configuration);
        this.eventBus.publish((XLReleaseEvent)new ConfigurationCreatedEvent(configuration));
    }

    public BaseConfiguration read(String id) {
        Object baseConfiguration = this.configurationRepository.read(id);
        Object t = baseConfiguration;
        if (t instanceof ThemeSettings) {
            ThemeSettings themeSettings = (ThemeSettings)t;
            return this.convertColorNameToCode(themeSettings);
        }
        return t;
    }

    @Timed
    public boolean exists(String id) {
        return this.configurationRepository.exists(id);
    }

    @Timed
    public void delete(String id) {
        block3: {
            block2: {
                String string = id;
                String string2 = "Configuration/settings/ThemeSettings";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                String string3 = id;
                String string4 = "Configuration/settings/CustomLogoSettings";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
            }
            throw new IllegalArgumentException("Configuration with id " + id + " can't be deleted");
        }
        Object conf = this.configurationRepository.read(id);
        this.configurationRepository.delete(id);
        this.eventBus.publish((XLReleaseEvent)new ConfigurationDeletedEvent(conf));
    }

    @Timed
    public ThemeSettings getThemeSettings() {
        ThemeSettings themeSettings = this.configurationRepository.getThemeSettings();
        return this.convertColorNameToCode(themeSettings);
    }

    private ThemeSettings convertColorNameToCode(ThemeSettings themeSettings) {
        themeSettings.setHeaderAccentColor(ThemeColors$.MODULE$.colorCode(ThemeColor.valueOf((String)themeSettings.getHeaderAccentColor().toUpperCase())));
        return themeSettings;
    }

    @Timed
    public CustomLogoSettings saveCustomLogo(CustomLogoSettings customLogoSettings) {
        customLogoSettings.validateContentType();
        return (CustomLogoSettings)this.createOrUpdate("Configuration/settings/CustomLogoSettings", (BaseConfiguration)customLogoSettings);
    }

    @Timed
    public List<FeatureSettings> getFeatureSettings() {
        Buffer features = CollectionConverters$.MODULE$.ListHasAsScala(this.configurationRepository.findAllByType(Type.valueOf(FeatureSettings.class))).asScala();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(FeatureSettings.class))).asScala().map((Function1 & Serializable)featureType -> (FeatureSettings)features.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigurationService.$anonfun$getFeatureSettings$2(featureType, x$1))).getOrElse((Function0 & Serializable)() -> {
            FeatureSettings feature = (FeatureSettings)featureType.getDescriptor().newInstance("");
            feature.generateId();
            return feature;
        }))).toList().sortBy((Function1 & Serializable)x$2 -> x$2.getType().getDescriptor().getLabel(), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    @Timed
    public List<BaseSettings> getSystemSettings() {
        Buffer features = CollectionConverters$.MODULE$.ListHasAsScala(this.configurationRepository.findAllByType(Type.valueOf(BaseSettings.class))).asScala();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)features.toList().sortBy((Function1 & Serializable)x$3 -> x$3.getType().getDescriptor().getLabel(), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    @Timed
    public FeatureSettings getFeatureSettings(String featureType) {
        return (FeatureSettings)Try$.MODULE$.apply((Function0 & Serializable)() -> $this.configurationRepository.findFirstByType(Type.valueOf((String)featureType)).orElse(ConfigurationService.getDefaultSettings$1(featureType))).getOrElse((Function0 & Serializable)() -> ConfigurationService.getDefaultSettings$1(featureType));
    }

    @Timed
    public void saveFeatureSettings(List<FeatureSettings> features) {
        CollectionConverters$.MODULE$.ListHasAsScala(features).asScala().foreach((Function1 & Serializable)configuration -> {
            this.createOrUpdate(configuration);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void saveSettings(List<BaseSettings> settings) {
        CollectionConverters$.MODULE$.ListHasAsScala(settings).asScala().foreach((Function1 & Serializable)setting -> this.createOrUpdate(setting.getId(), (BaseConfiguration)setting));
    }

    public static final /* synthetic */ boolean $anonfun$getFeatureSettings$2(Type featureType$1, FeatureSettings x$1) {
        Type type = x$1.getType();
        Type type2 = featureType$1;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    private static final FeatureSettings getDefaultSettings$1(String featureType$2) {
        FeatureSettings feature = (FeatureSettings)Type.valueOf((String)featureType$2).getDescriptor().newInstance("");
        feature.generateId();
        return feature;
    }

    public ConfigurationService(ConfigurationRepository configurationRepository, XLReleaseEventBus eventBus) {
        this.configurationRepository = configurationRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

