/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.spi.event.RoleDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.RolePermissionsChangedEvent;
import com.xebialabs.deployit.engine.spi.event.RolePrincipalsChangedEvent;
import com.xebialabs.deployit.engine.spi.event.RoleRenamedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.xlrelease.api.v1.filters.RolePrincipalsFilters;
import com.xebialabs.xlrelease.domain.events.GlobalRolesOrPermissionsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker$;
import com.xebialabs.xlrelease.security.ReleaseRolePermissionRepository;
import com.xebialabs.xlrelease.security.ReleaseRoleRepository;
import com.xebialabs.xlrelease.security.ReleaseRoleService;
import com.xebialabs.xlrelease.security.RolePermission;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.views.RolePrincipalsView;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t}c\u0001B\f\u0019\u0001\u0005B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A!\b\u0001B\u0001B\u0003%1\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u001d\tY\u0001\u0001C!\u0003\u001bAq!a\u0015\u0001\t\u0003\n)\u0006C\u0004\u0002z\u0001!\t%a\u001f\t\u000f\u0005\u0015\u0005\u0001\"\u0011\u0002\b\"9\u00111\u0013\u0001\u0005B\u0005U\u0005bBAO\u0001\u0011\u0005\u0013q\u0014\u0005\b\u0003W\u0003A\u0011IAW\u0011\u001d\t\u0019\f\u0001C!\u0003kCq!!1\u0001\t\u0003\n\u0019\rC\u0004\u0002n\u0002!\t%a<\t\u000f\u0005}\b\u0001\"\u0011\u0003\u0002!9!q\u0003\u0001\u0005B\te\u0001b\u0002B\u0014\u0001\u0011\u0005#\u0011\u0006\u0005\b\u0005s\u0001A\u0011\tB\u001e\u0011\u001d\u0011Y\u0005\u0001C\u0005\u0005\u001bBqA!\u0017\u0001\t\u0013\u0011YFA\rEK\u001a\fW\u000f\u001c;SK2,\u0017m]3S_2,7+\u001a:wS\u000e,'BA\r\u001b\u0003!\u0019XmY;sSRL(BA\u000e\u001d\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001e=\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002?\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g!\tI#&D\u0001\u0019\u0013\tY\u0003D\u0001\nSK2,\u0017m]3S_2,7+\u001a:wS\u000e,\u0017!\u0005=m%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vgB\u0011a&M\u0007\u0002_)\u0011\u0001GG\u0001\u0007KZ,g\u000e^:\n\u0005Iz#!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006Y1-[%e'\u0016\u0014h/[2f!\t)\u0004(D\u00017\u0015\t9$$A\u0004tKJ4\u0018nY3\n\u0005e2$aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\fQC]3mK\u0006\u001cXMU8mKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002*y%\u0011Q\b\u0007\u0002\u0016%\u0016dW-Y:f%>dWMU3q_NLGo\u001c:z\u0003}\u0011X\r\\3bg\u0016\u0014v\u000e\\3QKJl\u0017n]:j_:\u0014V\r]8tSR|'/\u001f\t\u0003S\u0001K!!\u0011\r\u0003?I+G.Z1tKJ{G.\u001a)fe6L7o]5p]J+\u0007o\\:ji>\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0006\t\u00163u\t\u0013\t\u0003S\u0001AQ\u0001L\u0003A\u00025BQaM\u0003A\u0002QBQAO\u0003A\u0002mBQAP\u0003A\u0002}\nabZ3u\u000f2|'-\u00197S_2,7\u000f\u0006\u0003L5\u001e\u001c\bc\u0001'R'6\tQJ\u0003\u0002O\u001f\u0006!Q\u000f^5m\u0015\u0005\u0001\u0016\u0001\u00026bm\u0006L!AU'\u0003\t1K7\u000f\u001e\t\u0003)bk\u0011!\u0016\u0006\u00033YS!a\u0016\u000f\u0002\u0011\u0011,\u0007\u000f\\8zSRL!!W+\u0003\tI{G.\u001a\u0005\u00067\u001a\u0001\r\u0001X\u0001\fe>dW\rU1ui\u0016\u0014h\u000e\u0005\u0002^I:\u0011aL\u0019\t\u0003?\u0012j\u0011\u0001\u0019\u0006\u0003C\u0002\na\u0001\u0010:p_Rt\u0014BA2%\u0003\u0019\u0001&/\u001a3fM&\u0011QM\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\r$\u0003\"\u00025\u0007\u0001\u0004I\u0017A\u00029bO&tw\r\u0005\u0002kc6\t1N\u0003\u0002m[\u0006\u0019A\r^8\u000b\u00059|\u0017aA1qS*\u0011\u0001OV\u0001\u0007K:<\u0017N\\3\n\u0005I\\'A\u0002)bO&tw\rC\u0003u\r\u0001\u0007Q/A\u0003pe\u0012,'\u000f\u0005\u0002km&\u0011qo\u001b\u0002\t\u001fJ$WM]5oO\"\u0012a!\u001f\t\u0004u\u0006\u001dQ\"A>\u000b\u0005ql\u0018AC1o]>$\u0018\r^5p]*\u0011ap`\u0001\u0005G>\u0014XM\u0003\u0003\u0002\u0002\u0005\r\u0011AC7jGJ|W.\u001a;fe*\u0011\u0011QA\u0001\u0003S>L1!!\u0003|\u0005\u0015!\u0016.\\3e\u0003m9W\r^$m_\n\fGNU8mKB\u0013\u0018N\\2ja\u0006dg+[3xgR1\u0011qBA\u001a\u0003\u000f\u0002b!!\u0005\u0002$\u0005\u001dRBAA\n\u0015\u0011\t)\"a\u0006\u0002\r\u0011|W.Y5o\u0015\u0011\tI\"a\u0007\u0002\t\u0011\fG/\u0019\u0006\u0005\u0003;\ty\"A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\t\t#A\u0002pe\u001eLA!!\n\u0002\u0014\t!\u0001+Y4f!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u00175\u0005)a/[3xg&!\u0011\u0011GA\u0016\u0005I\u0011v\u000e\\3Qe&t7-\u001b9bYN4\u0016.Z<\t\u000f\u0005Ur\u00011\u0001\u00028\u00059a-\u001b7uKJ\u001c\b\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005U\u0012Q\b\u0006\u0005\u0003\u007f\t\t%\u0001\u0002wc)\u0011aNG\u0005\u0005\u0003\u000b\nYDA\u000bS_2,\u0007K]5oG&\u0004\u0018\r\\:GS2$XM]:\t\u000f\u0005%s\u00011\u0001\u0002L\u0005A\u0001/Y4fC\ndW\r\u0005\u0003\u0002\u0012\u00055\u0013\u0002BA(\u0003'\u0011\u0001\u0002U1hK\u0006\u0014G.\u001a\u0015\u0003\u000fe\faa\u0019:fCR,GCBA,\u0003;\n\t\u0007E\u0002$\u00033J1!a\u0017%\u0005\u0011)f.\u001b;\t\r\u0005}\u0003\u00021\u0001]\u0003MygnQ8oM&<WO]1uS>t\u0017\n^3n\u0011\u001d\t\u0019\u0007\u0003a\u0001\u0003K\nQA]8mKN\u0004BaIA4'&\u0019\u0011\u0011\u000e\u0013\u0003\u0015q\u0012X\r]3bi\u0016$g\bK\u0002\t\u0003[\u0002B!a\u001c\u0002t5\u0011\u0011\u0011\u000f\u0006\u0003y\u0012JA!!\u001e\u0002r\t9a/\u0019:be\u001e\u001c\bF\u0001\u0005z\u0003\u0019)\b\u000fZ1uKR1\u0011qKA?\u0003\u007fBa!a\u0018\n\u0001\u0004a\u0006bBA2\u0013\u0001\u0007\u0011Q\r\u0015\u0004\u0013\u00055\u0004FA\u0005z\u0003A\u0011XM\\1nK\u001ecwNY1m%>dW\r\u0006\u0004\u0002X\u0005%\u0015Q\u0012\u0005\u0007\u0003\u0017S\u0001\u0019\u0001/\u0002\u000f=dGMT1nK\"1\u0011q\u0012\u0006A\u0002q\u000bqA\\3x\u001d\u0006lW\r\u000b\u0002\u000bs\u0006\u0001B-\u001a7fi\u0016<En\u001c2bYJ{G.\u001a\u000b\u0005\u0003/\n9\n\u0003\u0004\u0002\u001a.\u0001\r\u0001X\u0001\te>dWMT1nK\"\u00121\"_\u0001\u000eO\u0016$x\t\\8cC2\u0014v\u000e\\3\u0015\t\u0005\u0005\u0016q\u0015\t\u0005G\u0005\r6+C\u0002\u0002&\u0012\u0012aa\u00149uS>t\u0007BBAM\u0019\u0001\u0007A\f\u000b\u0002\rs\u0006Yr-\u001a;HY>\u0014\u0017\r\u001c*pY\u0016\u0004&/\u001b8dSB\fGn\u001d,jK^$B!a\n\u00020\"1\u0011\u0011T\u0007A\u0002qC#!D=\u0002!\u001ddwNY1m%>dW-\u0012=jgR\u001cH\u0003BA\\\u0003{\u00032aIA]\u0013\r\tY\f\n\u0002\b\u0005>|G.Z1o\u0011\u0019\tIJ\u0004a\u00019\"\u0012a\"_\u0001#GJ,\u0017\r^3HY>\u0014\u0017\r\u001c*pY\u0016\fe\u000e\u001a*pY\u0016\u0004VM]7jgNLwN\\:\u0015\t\u0005]\u0013Q\u0019\u0005\b\u0003\u000f|\u0001\u0019AAe\u0003!\u0011X-];fgR\u001c\b#B\u0012\u0002h\u0005-\u0007\u0003BAg\u0003GtA!a4\u0002`:!\u0011\u0011[Ao\u001d\u0011\t\u0019.a7\u000f\t\u0005U\u0017\u0011\u001c\b\u0004?\u0006]\u0017\"A\u0010\n\u0005uq\u0012BA\u000e\u001d\u0013\tI\"$C\u0002\u0002bb\t!CU3mK\u0006\u001cXMU8mKN+'O^5dK&!\u0011Q]At\u0005E\u0011v\u000e\\3De\u0016\fG/\u001a*fcV,7\u000f\u001e\u0006\u0004\u0003CD\u0002fA\b\u0002n!\u0012q\"_\u0001#kB$\u0017\r^3HY>\u0014\u0017\r\u001c*pY\u0016\fe\u000e\u001a*pY\u0016\u0004VM]7jgNLwN\\:\u0015\t\u0005]\u0013\u0011\u001f\u0005\b\u0003\u000f\u0004\u0002\u0019AAz!\u0015\u0019\u0013qMA{!\u0011\ti-a>\n\t\u0005e\u0018q\u001d\u0002\u0012%>dW-\u00169eCR,'+Z9vKN$\bf\u0001\t\u0002n!\u0012\u0001#_\u0001\u0019O\u0016$x\t\\8cC2\u0014v\u000e\\3QKJl\u0017n]:j_:\u001cH\u0003\u0002B\u0002\u0005\u0013\u0001B!!4\u0003\u0006%!!qAAt\u0005U9En\u001c2bYJ{G.\u001a)fe6L7o]5p]NDqAa\u0003\u0012\u0001\u0004\u0011i!A\u0004s_2,\u0017\nZ:\u0011\u000b\r\n9Ga\u0004\u0011\t\u00055'\u0011C\u0005\u0005\u0005'\t9O\u0001\u0004S_2,\u0017\n\u001a\u0015\u0003#e\f!cZ3u%>dW\rU3s[&\u001c8/[8ogR!!1\u0004B\u0011!\u0011\tiM!\b\n\t\t}\u0011q\u001d\u0002\u0010!\u0016\u0014X.[:tS>tg*Y7fg\"9!1\u0005\nA\u0002\t=\u0011A\u0002:pY\u0016LE\r\u000b\u0002\u0013s\u0006Y2M]3bi\u0016<En\u001c2bYJ{G.\u001a)fe6L7o]5p]N$B!a\u0016\u0003,!9\u0011qY\nA\u0002\t5\u0002#B\u0012\u0002h\t=\u0002\u0003BAg\u0005cIAAa\r\u0002h\nY\"k\u001c7f!\u0016\u0014X.[:tS>t7I]3bi\u0016\u0014V-];fgRD3aEA7Q\t\u0019\u00120A\u000eva\u0012\fG/Z$m_\n\fGNU8mKB+'/\\5tg&|gn\u001d\u000b\u0005\u0003/\u0012i\u0004C\u0004\u0002HR\u0001\rAa\u0010\u0011\u000b\r\n9G!\u0011\u0011\t\u00055'1I\u0005\u0005\u0005\u000b\n9OA\u000eS_2,\u0007+\u001a:nSN\u001c\u0018n\u001c8Va\u0012\fG/\u001a*fcV,7\u000f\u001e\u0015\u0004)\u00055\u0004F\u0001\u000bz\u0003}1\u0017N]3S_2,\u0007+\u001a:nSN\u001c\u0018n\u001c8t\u0007\"\fgnZ3e\u000bZ,g\u000e\u001e\u000b\u0005\u0003/\u0012y\u0005C\u0004\u0002HV\u0001\rA!\u0015\u0011\u000b\r\n9Ga\u0015\u0011\t\u00055'QK\u0005\u0005\u0005/\n9O\u0001\u000bS_2,\u0007+\u001a:nSN\u001c\u0018n\u001c8DQ\u0006tw-Z\u0001\u001eM&\u0014XMU8mKB\u0013\u0018N\\2ja\u0006d7\t[1oO\u0016,e/\u001a8ugR!\u0011q\u000bB/\u0011\u001d\t\u0019G\u0006a\u0001\u0003K\u0002")
public class DefaultReleaseRoleService
implements ReleaseRoleService {
    private final XLReleaseEventBus xlReleaseEventBus;
    private final CiIdService ciIdService;
    private final ReleaseRoleRepository releaseRoleRepository;
    private final ReleaseRolePermissionRepository releaseRolePermissionRepository;

    @Override
    public List<Role> getGlobalRoles() {
        return ReleaseRoleService.getGlobalRoles$(this);
    }

    @Override
    public void create(scala.collection.immutable.Seq<Role> roles) {
        ReleaseRoleService.create$((ReleaseRoleService)this, roles);
    }

    @Override
    public void update(scala.collection.immutable.Seq<Role> roles) {
        ReleaseRoleService.update$((ReleaseRoleService)this, roles);
    }

    @Override
    public void create(Role ... roles) {
        ReleaseRoleService.create$((ReleaseRoleService)this, roles);
    }

    @Override
    public void update(Role ... roles) {
        ReleaseRoleService.update$((ReleaseRoleService)this, roles);
    }

    @Override
    public java.util.Map<String, Set<String>> getGlobalRolePermissions(String ... roleIds) {
        return ReleaseRoleService.getGlobalRolePermissions$(this, roleIds);
    }

    @Override
    public void create(String onConfigurationItem, Role ... roles) {
        this.create(onConfigurationItem, (scala.collection.immutable.Seq<Role>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])roles));
    }

    @Override
    public void update(String onConfigurationItem, Role ... roles) {
        this.update(onConfigurationItem, (scala.collection.immutable.Seq<Role>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])roles));
    }

    @Override
    public void createGlobalRoleAndRolePermissions(ReleaseRoleService.RoleCreateRequest ... requests) {
        this.createGlobalRoleAndRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RoleCreateRequest>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])requests));
    }

    @Override
    public void updateGlobalRoleAndRolePermissions(ReleaseRoleService.RoleUpdateRequest ... requests) {
        this.updateGlobalRoleAndRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RoleUpdateRequest>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])requests));
    }

    @Override
    public void createGlobalRolePermissions(ReleaseRoleService.RolePermissionCreateRequest ... requests) {
        this.createGlobalRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionCreateRequest>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])requests));
    }

    @Override
    public void updateGlobalRolePermissions(ReleaseRoleService.RolePermissionUpdateRequest ... requests) {
        this.updateGlobalRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionUpdateRequest>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])requests));
    }

    @Override
    @Timed
    public List<Role> getGlobalRoles(String rolePattern, Paging paging, Ordering order) {
        return this.releaseRoleRepository.getGlobalRoles(rolePattern, paging, order);
    }

    @Override
    @Timed
    public Page<RolePrincipalsView> getGlobalRolePrincipalViews(RolePrincipalsFilters filters, Pageable pageable) {
        return this.releaseRoleRepository.getGlobalRolePrincipals(filters, pageable);
    }

    @Override
    @Timed
    public void create(String onConfigurationItem, scala.collection.immutable.Seq<Role> roles) {
        this.releaseRoleRepository.create(onConfigurationItem, roles);
        this.fireRolePrincipalChangeEvents(roles);
    }

    @Override
    @Timed
    public void update(String onConfigurationItem, scala.collection.immutable.Seq<Role> roles) {
        this.releaseRoleRepository.update(onConfigurationItem, roles);
        this.fireRolePrincipalChangeEvents(roles);
    }

    @Override
    @Timed
    public void renameGlobalRole(String oldName, String newName) {
        this.releaseRoleRepository.renameGlobalRole(oldName, newName);
        EventBusHolder.publish((Object)new RoleRenamedEvent(oldName, newName));
        this.xlReleaseEventBus.publish((XLReleaseEvent)new GlobalRolesOrPermissionsUpdatedEvent());
    }

    @Override
    @Timed
    public void deleteGlobalRole(String roleName) {
        Role foundRole = (Role)this.releaseRoleRepository.getGlobalRole(roleName).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find the role [%s]", new Object[]{roleName});
        });
        this.releaseRoleRepository.deleteGlobalRole(foundRole.getId());
        EventBusHolder.publish((Object)new RoleDeletedEvent(roleName));
        this.xlReleaseEventBus.publish((XLReleaseEvent)new GlobalRolesOrPermissionsUpdatedEvent());
    }

    @Override
    @Timed
    public Option<Role> getGlobalRole(String roleName) {
        return this.releaseRoleRepository.getGlobalRole(roleName);
    }

    @Override
    @Timed
    public RolePrincipalsView getGlobalRolePrincipalsView(String roleName) {
        return (RolePrincipalsView)this.releaseRoleRepository.getGlobalRolePrincipal(roleName).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Role [" + roleName + "] not found", new Object[0]);
        });
    }

    @Override
    @Timed
    public boolean globalRoleExists(String roleName) {
        return this.releaseRoleRepository.globalRoleExists(roleName);
    }

    @Override
    @Timed
    public void createGlobalRoleAndRolePermissions(scala.collection.immutable.Seq<ReleaseRoleService.RoleCreateRequest> requests) {
        Tuple2 tuple2 = ((IterableOps)requests.map((Function1 & Serializable)request -> {
            String roleId = Ids.getName((String)$this.ciIdService.getUniqueId("Role", TeamService.GLOBAL_ROLES_ROOT));
            Role role = new Role(roleId, request.roleName(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)CollectionConverters$.MODULE$.SetHasAsScala(request.rolePrincipals()).asScala().toList()).asJava());
            ReleaseRoleService.RolePermissionCreateRequest rolePermission = new ReleaseRoleService.RolePermissionCreateRequest(roleId, role.getName(), request.rolePermissions());
            return new Tuple2((Object)role, (Object)rolePermission);
        })).unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq roles = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq rolePermissions = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)roles, (Object)rolePermissions);
        scala.collection.immutable.Seq roles2 = (scala.collection.immutable.Seq)tuple22._1();
        scala.collection.immutable.Seq rolePermissions2 = (scala.collection.immutable.Seq)tuple22._2();
        this.create((scala.collection.immutable.Seq<Role>)roles2);
        this.createGlobalRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionCreateRequest>)rolePermissions2);
        this.xlReleaseEventBus.publish((XLReleaseEvent)new GlobalRolesOrPermissionsUpdatedEvent());
    }

    @Override
    @Timed
    public void updateGlobalRoleAndRolePermissions(scala.collection.immutable.Seq<ReleaseRoleService.RoleUpdateRequest> requests) {
        Tuple2 tuple2 = ((IterableOps)requests.map((Function1 & Serializable)request -> {
            Role role = new Role(request.roleId(), request.roleName(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)CollectionConverters$.MODULE$.SetHasAsScala(request.rolePrincipals()).asScala().toList()).asJava());
            ReleaseRoleService.RolePermissionUpdateRequest rolePermission = new ReleaseRoleService.RolePermissionUpdateRequest(request.roleId(), role.getName(), request.rolePermissions());
            return new Tuple2((Object)role, (Object)rolePermission);
        })).unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq roles = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq rolePermissionRequests = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)roles, (Object)rolePermissionRequests);
        scala.collection.immutable.Seq roles2 = (scala.collection.immutable.Seq)tuple22._1();
        scala.collection.immutable.Seq rolePermissionRequests2 = (scala.collection.immutable.Seq)tuple22._2();
        this.update((scala.collection.immutable.Seq<Role>)roles2);
        this.updateGlobalRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionUpdateRequest>)rolePermissionRequests2);
        this.xlReleaseEventBus.publish((XLReleaseEvent)new GlobalRolesOrPermissionsUpdatedEvent());
    }

    @Override
    @Timed
    public java.util.Map<String, Set<String>> getGlobalRolePermissions(scala.collection.immutable.Seq<String> roleIds) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)this.releaseRolePermissionRepository.getGlobalRolePermissions(roleIds).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends RolePermission, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String roleId = A1.roleId();
                    Set<String> rps = A1.permissionNames();
                    return (B1)new Tuple2((Object)roleId, rps);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(RolePermission x1) {
                RolePermission rolePermission = x1;
                return rolePermission != null;
            }
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    @Override
    @Timed
    public Set<String> getRolePermissions(String roleId) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.releaseRolePermissionRepository.getRolePermissions(roleId)).asJava();
    }

    @Override
    @Timed
    public void createGlobalRolePermissions(scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionCreateRequest> requests) {
        scala.collection.immutable.Seq rolePermissions = (scala.collection.immutable.Seq)requests.map((Function1 & Serializable)request -> new RolePermission(request.roleId(), request.permissionNames()));
        this.releaseRolePermissionRepository.createGlobalRolePermissions((scala.collection.immutable.Seq<RolePermission>)rolePermissions);
        this.fireRolePermissionsChangedEvent(requests);
    }

    @Override
    @Timed
    public void updateGlobalRolePermissions(scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionUpdateRequest> requests) {
        scala.collection.immutable.Seq rolePermissions = (scala.collection.immutable.Seq)requests.map((Function1 & Serializable)request -> new RolePermission(request.roleId(), request.permissionNames()));
        this.releaseRolePermissionRepository.updateGlobalRolePermissions((scala.collection.immutable.Seq<RolePermission>)rolePermissions);
        this.fireRolePermissionsChangedEvent(requests);
    }

    private void fireRolePermissionsChangedEvent(scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionChange> requests) {
        scala.collection.immutable.Seq msgs = (scala.collection.immutable.Seq)requests.map((Function1 & Serializable)request -> request.roleName() + " => " + request.permissionNames());
        EventBusHolder.publish((Object)new RolePermissionsChangedEvent(PermissionChecker$.MODULE$.GLOBAL_SECURITY_ALIAS(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)msgs).asJava()));
    }

    private void fireRolePrincipalChangeEvents(scala.collection.immutable.Seq<Role> roles) {
        scala.collection.immutable.Seq rolePrincipals = (scala.collection.immutable.Seq)roles.map((Function1 & Serializable)role -> role.getName() + " => " + role.getPrincipals());
        EventBusHolder.publish((Object)new RolePrincipalsChangedEvent(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)rolePrincipals).asJava()));
    }

    public DefaultReleaseRoleService(XLReleaseEventBus xlReleaseEventBus, CiIdService ciIdService, ReleaseRoleRepository releaseRoleRepository, ReleaseRolePermissionRepository releaseRolePermissionRepository) {
        this.xlReleaseEventBus = xlReleaseEventBus;
        this.ciIdService = ciIdService;
        this.releaseRoleRepository = releaseRoleRepository;
        this.releaseRolePermissionRepository = releaseRolePermissionRepository;
        ReleaseRoleService.$init$(this);
    }
}

