/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RepositoryInitializer;
import com.xebialabs.deployit.upgrade.UpgradeRejectedException;
import com.xebialabs.deployit.upgrade.Upgrader;
import com.xebialabs.xlplatform.spring.JythonBindingsHolder;
import com.xebialabs.xlplatform.upgrade.UpgraderHelper;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.XLReleaseServiceHolder;
import com.xebialabs.xlrelease.config.TypedWebhookFeatureToggleCondition;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.db.XLReleaseDbInitializer;
import com.xebialabs.xlrelease.events.EventListenerRegister;
import com.xebialabs.xlrelease.script.bindings.SecurityApiBinding;
import com.xebialabs.xlrelease.service.DatacenterService;
import com.xebialabs.xlrelease.service.MissingTypesChecker;
import com.xebialabs.xlrelease.service.XlrServiceManager;
import com.xebialabs.xlrelease.upgrade.liquibase.BeforeLiquibaseUpgrade;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"permissionCheckerHolder"})
public class ServiceStarter
implements SmartLifecycle {
    public static final int LIFECYCLE_PHASE = -1;
    private boolean running = false;
    private final Upgrader upgrader;
    private final RepositoryInitializer repositoryInitializer;
    private final XlrServiceManager serviceManager;
    private final XlrConfig xlrConfig;
    private final MissingTypesChecker missingTypesChecker;
    private XLReleaseDbInitializer xlrMigrationsDbInitializer;
    private XLReleaseDbInitializer xlrRepositoryDbInitializer;
    private XLReleaseDbInitializer reportingDbInitializer;
    private EventListenerRegister eventListenerRegister;
    private BeforeLiquibaseUpgrade beforeLiquibaseUpgrade;
    private List<? extends ApiService> apiServices;
    private SecurityApiBinding securityApiBinding;
    private DatacenterService datacenterService;
    private static final Logger logger = LoggerFactory.getLogger(ServiceStarter.class);

    @Autowired
    public ServiceStarter(Upgrader upgrader, RepositoryInitializer repositoryInitializer, XlrServiceManager serviceManager, XlrConfig xlrConfig, MissingTypesChecker missingTypesChecker, BeforeLiquibaseUpgrade beforeLiquibaseUpgrade, @Qualifier(value="xlrMigrationsDbInitializer") XLReleaseDbInitializer xlrMigrationsDbInitializer, @Qualifier(value="xlrRepositoryDbInitializer") XLReleaseDbInitializer xlrRepositoryDbInitializer, @Qualifier(value="reportingDbInitializer") XLReleaseDbInitializer reportingDbInitializer, EventListenerRegister eventListenerRegister, SecurityApiBinding securityApiBinding, DatacenterService datacenterService) {
        this.upgrader = upgrader;
        this.repositoryInitializer = repositoryInitializer;
        this.serviceManager = serviceManager;
        this.xlrConfig = xlrConfig;
        this.missingTypesChecker = missingTypesChecker;
        this.beforeLiquibaseUpgrade = beforeLiquibaseUpgrade;
        this.xlrMigrationsDbInitializer = xlrMigrationsDbInitializer;
        this.xlrRepositoryDbInitializer = xlrRepositoryDbInitializer;
        this.reportingDbInitializer = reportingDbInitializer;
        this.eventListenerRegister = eventListenerRegister;
        this.securityApiBinding = securityApiBinding;
        this.datacenterService = datacenterService;
    }

    @Autowired
    public void setApiServices(List<? extends ApiService> apiServices) {
        this.apiServices = apiServices;
    }

    public void startServices() {
        if (!this.running) {
            Version xlrDataVersion;
            boolean shutdown = false;
            XLReleaseServiceHolder.init(this.apiServices);
            this.initEndpointsJythonBindings(this.apiServices);
            this.logScriptSecurityOptions();
            try {
                xlrDataVersion = this.upgrader.getComponentVersion("xl-release");
            }
            catch (RuntimeException e) {
                xlrDataVersion = null;
            }
            if (xlrDataVersion != null) {
                List allUpgrades = (List)this.upgrader.findUpgrades().get("xl-release");
                List upgrades = UpgraderHelper.filterApplicable((List)allUpgrades, (Version)xlrDataVersion);
                allUpgrades.clear();
                if (!upgrades.isEmpty()) {
                    if (this.xlrConfig.isVerifyUpgraderMode()) {
                        throw new RuntimeException("Upgrade verification failed, run upgrader in apply mode.");
                    }
                    try {
                        this.upgrader.askForUpgrade();
                    }
                    catch (UpgradeRejectedException e) {
                        shutdown = true;
                    }
                }
            }
            if (!shutdown) {
                this.beforeLiquibaseUpgrade.init();
                logger.info("Initializing databases.");
                this.xlrMigrationsDbInitializer.run();
                this.xlrRepositoryDbInitializer.run();
                this.reportingDbInitializer.run();
                this.repositoryInitializer.initializeComponents();
                this.runUpgradeFiles();
                this.missingTypesChecker.cleanup();
                if (new TypedWebhookFeatureToggleCondition().matches()) {
                    this.missingTypesChecker.disableMissingWebhookEventTypes();
                }
                this.eventListenerRegister.registerEventListeners();
                this.datacenterService.registerDatacenter();
                this.datacenterService.monitorDatacenterTargetState();
            }
        } else {
            logger.error("ServiceStarter is already running. Please check configuration and report a bug.");
        }
    }

    private void runUpgradeFiles() {
        boolean isVerifyMode = this.xlrConfig.isVerifyUpgraderMode();
        try {
            this.upgrader.autoUpgrade(isVerifyMode);
        }
        catch (UpgradeRejectedException exception) {
            if (isVerifyMode) {
                logger.error("Upgrade files verification failed: ", (Throwable)exception);
                throw new RuntimeException("Upgrade verification failed, run upgrader in apply mode.");
            }
            throw exception;
        }
    }

    private void initEndpointsJythonBindings(List<? extends ApiService> apiServices) {
        HashMap<String, SecurityApiBinding> bindings = new HashMap<String, SecurityApiBinding>();
        bindings.put(SecurityApiBinding.NAME, this.securityApiBinding);
        apiServices.forEach(apiService -> bindings.put(apiService.serviceName(), (SecurityApiBinding)apiService));
        JythonBindingsHolder.setBindings(Collections.unmodifiableMap(bindings));
    }

    private void logScriptSecurityOptions() {
        boolean hasSecurityManager = System.getSecurityManager() != null;
        boolean hasScriptSandbox = hasSecurityManager && this.xlrConfig.isScriptSandboxEnabled();
        logger.info("Configuring scripting engine - Java security is {}, script sandbox is {}.", (Object)(hasSecurityManager ? "configured" : "not configured"), (Object)(hasScriptSandbox ? "enabled" : "disabled"));
    }

    public void start() {
        try {
            this.startServices();
            this.running = true;
        }
        catch (Exception e) {
            logger.error("Failed to start services", (Throwable)e);
            throw e;
        }
    }

    public void stop() {
        this.datacenterService.cancelStateCheck();
        this.serviceManager.stop();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return -1;
    }
}

