/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plumbing.CSPFilter;
import com.xebialabs.deployit.plumbing.IgnoreUrlFilter;
import com.xebialabs.deployit.plumbing.LogbackFilter;
import com.xebialabs.deployit.plumbing.ModifiedResourceFilter;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.deployit.plumbing.SlowdownFilter;
import com.xebialabs.deployit.plumbing.SseDisableBufferingFilter;
import com.xebialabs.deployit.plumbing.UrlRedirectRewriteFilter;
import com.xebialabs.deployit.plumbing.VersionEnforcerFilter;
import com.xebialabs.deployit.plumbing.XlrAccessControlFilter;
import com.xebialabs.deployit.plumbing.XssSecurityHeadersFilter;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.xlplatform.endpoints.servlet.PekkoStreamServlet;
import com.xebialabs.xlplatform.endpoints.servlet.PekkoStreamServletInitializer;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.security.HttpSessionListenerWithTimeout;
import com.xebialabs.xlrelease.server.jetty.JettyEmbeddedErrorHandler;
import com.xebialabs.xlrelease.server.jetty.SSLConstants$;
import com.xebialabs.xlrelease.service.XlrServiceManager;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.jetty12.server.TimedHandler;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.SessionTrackingMode;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventListener;
import org.eclipse.jetty.ee10.servlet.ErrorHandler;
import org.eclipse.jetty.ee10.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.ee10.servlets.CrossOriginFilter;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.Configuration;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001\u0002\u0011\"\u00011B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005}!AQ\t\u0001BC\u0002\u0013\u0005a\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003H\u0011!q\u0005A!b\u0001\n\u0003y\u0005\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011]\u0003!\u0011!Q\u0001\naC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\u0006W\u0002!\t\u0001\u001c\u0005\u0006i\u0002!\t%\u001e\u0005\u0006y\u0002!\t& \u0005\b\u0003;\u0001A\u0011BA\u0010\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003KAq!!\f\u0001\t\u0013\ty\u0003C\u0004\u0002`\u0001!I!!\u0019\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h!9\u00111\u000e\u0001\u0005\n\u00055\u0004bBA9\u0001\u0011%\u00111\u000f\u0005\b\u0003o\u0002A\u0011BA=\u0011\u001d\ti\b\u0001C\u0005\u0003\u007fBq!a!\u0001\t\u0013\t)\tC\u0004\u0002\n\u0002!I!a#\t\u000f\u0005=\u0005\u0001\"\u0003\u0002\u0012\"9\u0011Q\u0013\u0001\u0005\n\u0005]\u0005bBAN\u0001\u0011%\u0011Q\u0014\u0005\b\u0003C\u0003A\u0011BAR\u0011\u001d\t9\u000b\u0001C\u0005\u0003SCq!!-\u0001\t\u0013\t\u0019\fC\u0004\u00028\u0002!I!!/\t\u000f\u0005e\u0007\u0001\"\u0003\u0002\\\"9\u0011q\u001c\u0001\u0005\n\u0005\u0005(a\t*fY\u0016\f7/\u001a&fiRL8+\u001a:wY\u0016$x+\u001a2TKJ4XM\u001d$bGR|'/\u001f\u0006\u0003E\r\nQA[3uifT!\u0001J\u0013\u0002\rM,'O^3s\u0015\t1s%A\u0005yYJ,G.Z1tK*\u0011\u0001&K\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AK\u0001\u0004G>l7\u0001A\n\u0003\u00015\u0002\"A\f\u001e\u000e\u0003=R!A\t\u0019\u000b\u0005E\u0012\u0014\u0001C3nE\u0016$G-\u001a3\u000b\u0005M\"\u0014aA<fE*\u0011QGN\u0001\u0005E>|GO\u0003\u00028q\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001:\u0003\ry'oZ\u0005\u0003w=\u0012ADS3uif\u001cVM\u001d<mKR<VMY*feZ,'OR1di>\u0014\u00180A\ntKJ4XM]\"p]\u001aLw-\u001e:bi&|g.F\u0001?!\ty$)D\u0001A\u0015\t\tu%\u0001\u0005eKBdw._5u\u0013\t\u0019\u0005IA\nTKJ4XM]\"p]\u001aLw-\u001e:bi&|g.\u0001\u000btKJ4XM]\"p]\u001aLw-\u001e:bi&|g\u000eI\u0001\nq2\u00148i\u001c8gS\u001e,\u0012a\u0012\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015\u0016\naaY8oM&<\u0017B\u0001'J\u0005%AFN]\"p]\u001aLw-\u0001\u0006yYJ\u001cuN\u001c4jO\u0002\n!\u0003]3s[&\u001c8/[8o\u000b:4wN]2feV\t\u0001\u000b\u0005\u0002R)6\t!K\u0003\u0002T\u0001\u0006A1/Z2ve&$\u00180\u0003\u0002V%\n\u0011\u0002+\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3s\u0003M\u0001XM]7jgNLwN\\#oM>\u00148-\u001a:!\u00035iW\r^3s%\u0016<\u0017n\u001d;ssB\u0011\u0011LY\u0007\u00025*\u00111\fX\u0001\u000bS:\u001cHO];nK:$(BA/_\u0003\u0011\u0019wN]3\u000b\u0005}\u0003\u0017AC7jGJ|W.\u001a;fe*\t\u0011-\u0001\u0002j_&\u00111M\u0017\u0002\u000e\u001b\u0016$XM\u001d*fO&\u001cHO]=\u0002\u001dM,'O^5dK6\u000bg.Y4feB\u0011a-[\u0007\u0002O*\u0011\u0001.J\u0001\bg\u0016\u0014h/[2f\u0013\tQwMA\tYYJ\u001cVM\u001d<jG\u0016l\u0015M\\1hKJ\fa\u0001P5oSRtDCB7paF\u00148\u000f\u0005\u0002o\u00015\t\u0011\u0005C\u0003=\u0013\u0001\u0007a\bC\u0003F\u0013\u0001\u0007q\tC\u0003O\u0013\u0001\u0007\u0001\u000bC\u0003X\u0013\u0001\u0007\u0001\fC\u0003e\u0013\u0001\u0007Q-\u0001\rjgJ+w-[:uKJ$UMZ1vYR\u001cVM\u001d<mKR$\u0012A\u001e\t\u0003ojl\u0011\u0001\u001f\u0006\u0002s\u0006)1oY1mC&\u00111\u0010\u001f\u0002\b\u0005>|G.Z1o\u0003a\u0001xn\u001d;Qe>\u001cWm]:XK\n\f\u0005\u000f]\"p]R,\u0007\u0010\u001e\u000b\u0004}\u0006\r\u0001CA<\u0000\u0013\r\t\t\u0001\u001f\u0002\u0005+:LG\u000fC\u0004\u0002\u0006-\u0001\r!a\u0002\u0002\u0017\r|g\u000e^3yiJ{w\u000e\u001e\t\u0005\u0003\u0013\tI\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u00199XMY1qa*!\u0011\u0011CA\n\u0003\u0011)W-\r\u0019\u000b\u0007\t\n)BC\u0002\u0002\u0018a\nq!Z2mSB\u001cX-\u0003\u0003\u0002\u001c\u0005-!!D,fE\u0006\u0003\boQ8oi\u0016DH/\u0001\u0006tKR,\bOS3uif$2A`A\u0011\u0011\u001d\t)\u0001\u0004a\u0001\u0003\u000f\t\u0011dZ3u\u000bJ\u0014xN\u001d)bO\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]R\u0011\u0011q\u0005\t\u0005\u0003\u0013\tI#\u0003\u0003\u0002,\u0005-!!D\"p]\u001aLw-\u001e:bi&|g.\u0001\nbI\u0012TU\r\u001e;z\u000bJ\u0014xN\u001d)bO\u0016\u001cH#\u0002@\u00022\u0005\u0005\u0003bBA\u001a\u001d\u0001\u0007\u0011QG\u0001\rKJ\u0014xN\u001d%b]\u0012dWM\u001d\t\u0005\u0003o\ti$\u0004\u0002\u0002:)!\u00111HA\b\u0003\u001d\u0019XM\u001d<mKRLA!a\u0010\u0002:\taQI\u001d:pe\"\u000bg\u000e\u001a7fe\"9\u00111\t\bA\u0002\u0005\u0015\u0013AC3se>\u0014\b+Y4fgB1\u0011qIA)\u0003+j!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\u0005kRLGN\u0003\u0002\u0002P\u0005!!.\u0019<b\u0013\u0011\t\u0019&!\u0013\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0003\u0002X\u0005mSBAA-\u0015\t!#'\u0003\u0003\u0002^\u0005e#!C#se>\u0014\b+Y4f\u0003I\u0019X\r^;q\u0019><'-Y2l\r&dG/\u001a:\u0015\u0007y\f\u0019\u0007C\u0004\u0002\u0006=\u0001\r!a\u0002\u0002\u0017M,G/\u001e9TaJLgn\u001a\u000b\u0004}\u0006%\u0004bBA\u0003!\u0001\u0007\u0011qA\u0001\u0010g\u0016$X\u000f]\"peN4\u0015\u000e\u001c;feR\u0019a0a\u001c\t\u000f\u0005\u0015\u0011\u00031\u0001\u0002\b\u0005i2/\u001a;vab\u001b8oU3dkJLG/\u001f%fC\u0012,'o\u001d$jYR,'\u000fF\u0002\u007f\u0003kBq!!\u0002\u0013\u0001\u0004\t9!\u0001\btKR,\b/\u0016:m\r&dG/\u001a:\u0015\u0007y\fY\bC\u0004\u0002\u0006M\u0001\r!a\u0002\u0002'M,G/\u001e9TY><Hm\\<o\r&dG/\u001a:\u0015\u0007y\f\t\tC\u0004\u0002\u0006Q\u0001\r!a\u0002\u0002\u001dM,G/\u001e9D'B3\u0015\u000e\u001c;feR\u0019a0a\"\t\u000f\u0005\u0015Q\u00031\u0001\u0002\b\u0005\t2/\u001a;va\u0016CH/\u001a8tS>t\u0017\t]5\u0015\u0007y\fi\tC\u0004\u0002\u0006Y\u0001\r!a\u0002\u0002)M,G/\u001e9WKJ\u001c\u0018n\u001c8F]\u001a|'oY3s)\rq\u00181\u0013\u0005\b\u0003\u000b9\u0002\u0019AA\u0004\u0003E\u0019X\r^;q%\u0016\fX/Z:u\u0019>\u001c\u0017\r\u001c\u000b\u0004}\u0006e\u0005bBA\u00031\u0001\u0007\u0011qA\u0001\u0015K:\f'\r\\3SKN|WO]2fg\u000e\u000b7\r[3\u0015\u0007y\fy\nC\u0004\u0002\u0006e\u0001\r!a\u0002\u0002#\u0015t\u0017M\u00197f\u000fjL\u0007\u000fS1oI2,'\u000fF\u0002\u007f\u0003KCq!!\u0002\u001b\u0001\u0004\t9!A\toK^\u001cVm]:j_:D\u0015M\u001c3mKJ,\"!a+\u0011\t\u0005]\u0012QV\u0005\u0005\u0003_\u000bID\u0001\bTKN\u001c\u0018n\u001c8IC:$G.\u001a:\u00023\u0015t\u0017M\u00197f\u0013:\u001cHO];nK:$X\r\u001a%b]\u0012dWM\u001d\u000b\u0004}\u0006U\u0006bBA\u00039\u0001\u0007\u0011qA\u0001\u0012g\u0016$\bK]8qKJ$\u00180\u00134Ok2dG#\u0002@\u0002<\u0006U\u0007bBA_;\u0001\u0007\u0011qX\u0001\u0004W\u0016L\b\u0003BAa\u0003\u001ftA!a1\u0002LB\u0019\u0011Q\u0019=\u000e\u0005\u0005\u001d'bAAeW\u00051AH]8pizJ1!!4y\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011[Aj\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u001a=\t\u000f\u0005]W\u00041\u0001\u0002@\u0006)a/\u00197vK\u0006A2/\u001a;va\u0006\u001b7-Z:t\u0007>tGO]8m\r&dG/\u001a:\u0015\u0007y\fi\u000eC\u0004\u0002\u0006y\u0001\r!a\u0002\u0002=M,G/\u001e9Tg\u0016$\u0015n]1cY\u0016\u0014UO\u001a4fe&twMR5mi\u0016\u0014Hc\u0001@\u0002d\"9\u0011QA\u0010A\u0002\u0005\u001d\u0001")
public class ReleaseJettyServletWebServerFactory
extends JettyServletWebServerFactory {
    private final ServerConfiguration serverConfiguration;
    private final XlrConfig xlrConfig;
    private final PermissionEnforcer permissionEnforcer;
    private final MeterRegistry meterRegistry;
    private final XlrServiceManager serviceManager;

    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public boolean isRegisterDefaultServlet() {
        return false;
    }

    public void postProcessWebAppContext(WebAppContext contextRoot) {
        this.setupJetty(contextRoot);
        this.setupLogbackFilter(contextRoot);
        this.setupSpring(contextRoot);
        this.setupCorsFilter(contextRoot);
        this.setupXssSecurityHeadersFilter(contextRoot);
        this.setupUrlFilter(contextRoot);
        this.setupCSPFilter(contextRoot);
        this.setupSlowdownFilter(contextRoot);
        this.setupExtensionApi(contextRoot);
        this.setupVersionEnforcer(contextRoot);
        this.setupRequestLocal(contextRoot);
        this.setupAccessControlFilter(contextRoot);
        this.setupSseDisableBufferingFilter(contextRoot);
    }

    private void setupJetty(WebAppContext contextRoot) {
        contextRoot.setSessionHandler(this.newSessionHandler());
        contextRoot.setSecurityHandler((SecurityHandler)new ConstraintSecurityHandler());
        contextRoot.addConfiguration(new Configuration[]{this.getErrorPageConfiguration()});
        if (this.xlrConfig().metrics().enabled()) {
            this.enableInstrumentedHandler(contextRoot);
        }
        if (this.xlrConfig().server_http_gzip_enabled()) {
            this.enableGzipHandler(contextRoot);
        }
        if (this.xlrConfig().server_http_cache_enabled() && Environment.isProduction()) {
            this.enableResourcesCache(contextRoot);
            return;
        }
    }

    private Configuration getErrorPageConfiguration() {
        return new AbstractConfiguration(this){
            private final /* synthetic */ ReleaseJettyServletWebServerFactory $outer;

            public void configure(WebAppContext context) {
                JettyEmbeddedErrorHandler errorHandler = new JettyEmbeddedErrorHandler();
                errorHandler.setShowServlet(false);
                errorHandler.setShowStacks(false);
                errorHandler.setShowMessageInTitle(false);
                context.setErrorHandler((Request.Handler)errorHandler);
                this.$outer.com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$addJettyErrorPages((ErrorHandler)errorHandler, this.$outer.getErrorPages());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(new AbstractConfiguration.Builder());
            }
        };
    }

    public void com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$addJettyErrorPages(ErrorHandler errorHandler, Collection<ErrorPage> errorPages) {
        ErrorHandler errorHandler2 = errorHandler;
        if (errorHandler2 instanceof ErrorPageErrorHandler) {
            ErrorPageErrorHandler errorPageErrorHandler = (ErrorPageErrorHandler)errorHandler2;
            CollectionConverters$.MODULE$.CollectionHasAsScala(errorPages).asScala().foreach((Function1 & Serializable)errorPage -> {
                ReleaseJettyServletWebServerFactory.$anonfun$addJettyErrorPages$1(errorPageErrorHandler, errorPage);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void setupLogbackFilter(WebAppContext contextRoot) {
        contextRoot.addFilter(LogbackFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
    }

    private void setupSpring(WebAppContext contextRoot) {
        this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PROPERTY(), this.serverConfiguration().getKeyStorePath());
        this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getKeyStorePassword());
        this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PROPERTY(), this.serverConfiguration().getTrustStorePath());
        this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getTrustStorePassword());
        contextRoot.addFilter(UrlRedirectRewriteFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        filter.setAsyncSupported(true);
        contextRoot.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder encodingFilter = new FilterHolder(CharacterEncodingFilter.class);
        encodingFilter.setName("encodingFilter");
        encodingFilter.setInitParameter("encoding", "UTF-8");
        encodingFilter.setInitParameter("forceEncoding", "true");
        encodingFilter.setAsyncSupported(true);
        contextRoot.addFilter(encodingFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        ResourceFactory resourceFactory = contextRoot.getResourceFactory();
        URI path = Path.of(".", new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toUri();
        Resource baseResource = resourceFactory.newResource(path);
        contextRoot.setBaseResource(baseResource);
        if (!this.xlrConfig().server_session_storage_enabled()) {
            contextRoot.addEventListener((EventListener)((Object)new HttpSessionListenerWithTimeout()));
            return;
        }
    }

    private void setupCorsFilter(WebAppContext contextRoot) {
        if (this.xlrConfig().api_corsEnabled()) {
            FilterHolder holder = new FilterHolder((Filter)new CrossOriginFilter());
            holder.setInitParameter("Access-Control-Allow-Origin", "*");
            holder.setInitParameter("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE, PUT");
            holder.setInitParameter("Access-Control-Allow-Headers", "x-requested-with, accept, origin, content-type");
            holder.setInitParameter("Access-Control-Max-Age", "3600");
            holder.setAsyncSupported(true);
            contextRoot.addFilter(holder, "/api/v1/*", EnumSet.of(DispatcherType.REQUEST));
            return;
        }
    }

    private void setupXssSecurityHeadersFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new XssSecurityHeadersFilter());
        holder.setAsyncSupported(true);
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupUrlFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new IgnoreUrlFilter());
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSlowdownFilter(WebAppContext contextRoot) {
        if (Environment.isDevelopment()) {
            long slowDownInMs = this.xlrConfig().development_restSlowDownDelay().toMillis();
            if (slowDownInMs > 0L) {
                this.logger.warn((Object)("Configuring slow down filter with " + slowDownInMs + " milliseconds."));
                FilterHolder slowdownFilter = new FilterHolder(SlowdownFilter.class);
                slowdownFilter.setInitParameter("ms", String.valueOf(slowDownInMs));
                slowdownFilter.setAsyncSupported(true);
                contextRoot.addFilter(slowdownFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
                return;
            }
            return;
        }
    }

    private void setupCSPFilter(WebAppContext contextRoot) {
        if (this.xlrConfig().server_http_csp_enabled()) {
            FilterHolder holder = new FilterHolder((Filter)new CSPFilter());
            holder.setAsyncSupported(true);
            holder.setInitParameter("policyDirectives", this.xlrConfig().server_http_csp_policyDirectives());
            contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
            return;
        }
    }

    private void setupExtensionApi(WebAppContext contextRoot) {
        String apiExtensionRootPath = this.xlrConfig().serverExtension_rootPath();
        String apiExtensionContext = String.format("%s/*", apiExtensionRootPath);
        ServletHolder extensionApiServletHolder = new ServletHolder(PekkoStreamServlet.class);
        extensionApiServletHolder.setDisplayName("ExtensionApiConnectorServlet");
        extensionApiServletHolder.setAsyncSupported(true);
        contextRoot.addEventListener((EventListener)new PekkoStreamServletInitializer(this.xlrConfig().extensionServletSystem().config()));
        contextRoot.addServlet(extensionApiServletHolder, apiExtensionContext);
    }

    private void setupVersionEnforcer(WebAppContext contextRoot) {
        if (!Environment.isDevelopment()) {
            contextRoot.addFilter(VersionEnforcerFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
            return;
        }
    }

    private void setupRequestLocal(WebAppContext contextRoot) {
        contextRoot.addFilter(RequestLocal.class, "*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
    }

    private void enableResourcesCache(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new ModifiedResourceFilter());
        holder.setInitParameter("startTimestamp", String.valueOf(System.currentTimeMillis()));
        holder.setAsyncSupported(true);
        contextRoot.addFilter(holder, "/static/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-module.js", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-plugins.js", EnumSet.of(DispatcherType.REQUEST));
    }

    private void enableGzipHandler(WebAppContext contextRoot) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setSyncFlush(true);
        gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT"});
        gzipHandler.setMinGzipSize(this.xlrConfig().server_http_gzip_minSize().intValue());
        gzipHandler.setExcludedPaths((String[])CollectionConverters$.MODULE$.ListHasAsScala(this.xlrConfig().server_http_gzip_excludedPaths()).asScala().toSeq().toArray(ClassTag$.MODULE$.apply(String.class)));
        gzipHandler.setDeflaterPool(new DeflaterPool(1024, this.xlrConfig().server_http_gzip_compression(), true));
        contextRoot.insertHandler((Handler.Singleton)gzipHandler);
    }

    private SessionHandler newSessionHandler() {
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
        sessionHandler.setHttpOnly(true);
        if (!this.serverConfiguration().isSsl()) {
            this.logger.debug((Object)("Setting up Secure Cookie Enabled to - " + this.serverConfiguration().isSecureCookieEnabled()));
            sessionHandler.getSessionCookieConfig().setSecure(this.serverConfiguration().isSecureCookieEnabled());
        }
        sessionHandler.setSameSite(HttpCookie.SameSite.valueOf((String)this.xlrConfig().server_http_cookie_sameSite().getAttributeValue().toUpperCase()));
        return sessionHandler;
    }

    private void enableInstrumentedHandler(WebAppContext contextRoot) {
        TimedHandler handler = new TimedHandler(this.meterRegistry, (Iterable)Tags.empty());
        contextRoot.insertHandler((Handler.Singleton)handler);
    }

    private void setPropertyIfNull(String key, String value) {
        if (value != null) {
            if (System.getProperty(key) == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting system property - " + key));
                }
                System.setProperty(key, value);
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Not overriding already specified system property - " + key));
                return;
            }
            return;
        }
    }

    private void setupAccessControlFilter(WebAppContext contextRoot) {
        FilterHolder filterHolder = new FilterHolder((Filter)new XlrAccessControlFilter(this.permissionEnforcer(), this.serviceManager, this.xlrConfig().maintenanceModeEnabled()));
        contextRoot.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSseDisableBufferingFilter(WebAppContext contextRoot) {
        FilterHolder filterHolder = new FilterHolder((Filter)new SseDisableBufferingFilter());
        contextRoot.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    public static final /* synthetic */ void $anonfun$addJettyErrorPages$1(ErrorPageErrorHandler x2$1, ErrorPage errorPage) {
        if (errorPage.isGlobal()) {
            x2$1.addErrorPage("org.eclipse.jetty.server.error_page.global", errorPage.getPath());
            return;
        }
        if (errorPage.getExceptionName() != null) {
            x2$1.addErrorPage(errorPage.getExceptionName(), errorPage.getPath());
            return;
        }
        x2$1.addErrorPage(errorPage.getStatusCode(), errorPage.getPath());
    }

    public ReleaseJettyServletWebServerFactory(ServerConfiguration serverConfiguration, XlrConfig xlrConfig, PermissionEnforcer permissionEnforcer, MeterRegistry meterRegistry, XlrServiceManager serviceManager) {
        this.serverConfiguration = serverConfiguration;
        this.xlrConfig = xlrConfig;
        this.permissionEnforcer = permissionEnforcer;
        this.meterRegistry = meterRegistry;
        this.serviceManager = serviceManager;
    }
}

