/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.repository.CustomPersistentTokenRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticatedPrincipal;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.stereotype.Service;

@Service
public class SessionService {
    private final SessionRegistry sessionRegistry;
    private final CustomPersistentTokenRepository customPersistentTokenRepository;

    @Autowired
    public SessionService(SessionRegistry sessionRegistry, CustomPersistentTokenRepository customPersistentTokenRepository) {
        this.sessionRegistry = sessionRegistry;
        this.customPersistentTokenRepository = customPersistentTokenRepository;
    }

    public void disconnect(String username) {
        if (XlrConfig.getInstance().server_session_storage_enabled()) {
            this.clearAllSessions(username);
        } else {
            List principals = this.sessionRegistry.getAllPrincipals();
            principals.stream().filter(AuthenticatedPrincipal.class::isInstance).filter(ap -> ((AuthenticatedPrincipal)ap).getName().equalsIgnoreCase(username)).forEach(this::clearAllSessions);
        }
        this.customPersistentTokenRepository.removeUserTokens(username);
    }

    private void clearAllSessions(Object principal) {
        for (SessionInformation session : this.sessionRegistry.getAllSessions(principal, false)) {
            session.expireNow();
        }
    }
}

