package com.xebialabs.deployit.plumbing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;


@Component
@Provider
@Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
@Consumes({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
public class ConfigurationItemReaderWriter extends AbstractConfigurationItemReaderWriter implements MessageBodyReader<ConfigurationItem>, MessageBodyWriter<ConfigurationItem> {

    @Autowired
    public ConfigurationItemReaderWriter(RepositoryFactory repositoryFactory, XlrFormatFactory formats, ConfigurationRepository configurationRepository) {
        super(repositoryFactory, formats, configurationRepository);
    }

    @Override
    public void writeTo(ConfigurationItem configurationItem, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders,
                        OutputStream entityStream) throws IOException, WebApplicationException {

        ConfigurationItemConverter converter = createConverter();
        PrintWriter outputWriter = new PrintWriter(entityStream, false, StandardCharsets.UTF_8);
        CiWriter writer = formats.createCiWriter(mediaType, outputWriter);
        converter.writeCi(configurationItem, writer, Integer.MAX_VALUE);
        outputWriter.flush();
    }

    @Override
    public ConfigurationItem readFrom(Class<ConfigurationItem> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders,
                                      InputStream entityStream) throws IOException, WebApplicationException {

        ConfigurationItemConverter converter = createConverter();
        CiReader reader = formats.createCiReader(entityStream, mediaType);
        ConfigurationItem result = converter.readCi(reader);
        // Resolve the CI references that were found by the converter while parsing.
        converter.resolveReferences(repository);
        return result;
    }

    @Override
    public long getSize(ConfigurationItem configurationItem, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

}
