package com.xebialabs.xlrelease.script.jython

import com.xebialabs.deployit.plumbing.ExecutionOutputWriter
import com.xebialabs.platform.script.jython.JythonSupport
import com.xebialabs.xlrelease.script.{OutputHandler, ScriptService, XlrScriptContext}
import com.xebialabs.xlrelease.utils.SensitiveValueScrubber
import grizzled.slf4j.Logger

import java.io.StringWriter
import scala.util.Try

trait XlrJythonSupport {

  def scriptService: ScriptService

  protected def logger: Logger

  def executeScript(scriptContext: XlrScriptContext): Unit = {
    val scrubber = SensitiveValueScrubber.disabled

    val logHandler = OutputHandler((l: String) => logger.info(l))
    val executionWriter = new ExecutionOutputWriter(scrubber, new StringWriter(), logHandler)
    JythonSupport.outWriterDecorator.registerWriter(executionWriter)
    scriptContext.setWriter(JythonSupport.outWriterDecorator)

    val errorLogHandler = OutputHandler((l: String) => logger.warn(l))
    val errorExecutionWriter = new ExecutionOutputWriter(scrubber, new StringWriter(), errorLogHandler)
    JythonSupport.errorWriterDecorator.registerWriter(errorExecutionWriter)
    scriptContext.setErrorWriter(JythonSupport.errorWriterDecorator)

    try {
      scriptService.executeScript(scriptContext)
    } finally {
      Try(JythonSupport.outWriterDecorator.close())
      Try(JythonSupport.errorWriterDecorator.close())
      Try(JythonSupport.outWriterDecorator.removeWriter())
      Try(JythonSupport.errorWriterDecorator.removeWriter())
    }
  }

}
