package com.xebialabs.xlrelease.service;

import java.io.InputStream;
import org.apache.tika.detect.DefaultDetector;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.utils.FileContentValidation;
import com.xebialabs.xlrelease.utils.UploadSettings;

import scala.util.Try;

@Component
public class FileContentValidator {

    private final DefaultDetector tikaDetector;
    private final UploadSettings uploadSettings;

    public FileContentValidator() {
        this.tikaDetector = new DefaultDetector();
        XlrConfig xlrConfig = XlrConfig.getInstance();
        this.uploadSettings = new UploadSettings(
                xlrConfig.server().upload().shouldAnalyzeContent(),
                xlrConfig.server().upload().allowedFileTypes()
        );
    }

    public Try<InputStream> validate(String filename, InputStream in) {
        return FileContentValidation.filter(tikaDetector, uploadSettings, filename, in);
    }
}
