/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.xlrelease.api.utils.ResponseHelper;
import com.xebialabs.xlrelease.api.v1.ReleaseApi;
import com.xebialabs.xlrelease.calendar.ReleaseCalendar;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ReleaseService;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/export")
@Controller
public class ExportResource {
    private static final String ICS_CONTENT_TYPE = "text/calendar";
    private static final String ICS_EXTENSION = ".ics";
    private final PermissionChecker permissions;
    private final ReleaseService releaseService;
    private final ReleaseApi releaseApi;

    @Autowired
    public ExportResource(PermissionChecker permissions, ReleaseService releaseService, ReleaseApi releaseApi) {
        this.permissions = permissions;
        this.releaseService = releaseService;
        this.releaseApi = releaseApi;
    }

    @GET
    @Path(value="attachments/{attachmentId}")
    @Produces(value={"application/octet-stream"})
    public Response downloadAttachment(@PathParam(value="attachmentId") @IdParam String attachmentId) {
        return this.releaseApi.downloadAttachment(attachmentId);
    }

    @GET
    @Path(value="calendar/{releaseId}")
    @Produces(value={"application/octet-stream"})
    public Response exportReleaseToCalendar(@PathParam(value="releaseId") @IdParam String releaseId) {
        Release release = this.releaseService.findByIdIncludingArchived(releaseId);
        this.permissions.checkView(release);
        this.releaseService.decorateRemovingUnnecessaryFields(release);
        String calendarContent = new ReleaseCalendar(release).toString();
        StreamingOutput output = outputStream -> outputStream.write(calendarContent.getBytes("UTF-8"));
        String fileName = release.getTitle() + ICS_EXTENSION;
        return ResponseHelper.streamFile(fileName, output, ICS_CONTENT_TYPE);
    }
}

