/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.TenantApi;
import com.xebialabs.xlrelease.api.v1.forms.TenantLinkRequest;
import com.xebialabs.xlrelease.api.v1.forms.TenantRequest;
import com.xebialabs.xlrelease.configuration.TenantLimit;
import com.xebialabs.xlrelease.domain.Tenant;
import com.xebialabs.xlrelease.domain.status.TenantStatus;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.TenantLimitService;
import com.xebialabs.xlrelease.service.TenantService;
import io.micrometer.core.annotation.Timed;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005]d\u0001\u0002\t\u0012\u0001yA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!A\u0011\b\u0001B\u0001B\u0003%!\bC\u0003>\u0001\u0011\u0005a\bC\u0003E\u0001\u0011\u0005S\tC\u0003`\u0001\u0011\u0005\u0003\rC\u0003r\u0001\u0011\u0005#\u000fC\u0003}\u0001\u0011\u0005S\u0010C\u0004\u0002\f\u0001!\t%!\u0004\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016!9\u0011q\u0005\u0001\u0005B\u0005%\u0002bBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!!\u0014\u0001\t\u0003\nyEA\u0007UK:\fg\u000e^!qS&k\u0007\u000f\u001c\u0006\u0003%M\tA![7qY*\u0011A#F\u0001\u0003mFR!AF\f\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u00193\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00035m\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003q\t1aY8n\u0007\u0001\u00192\u0001A\u0010(!\t\u0001S%D\u0001\"\u0015\t\u00113%\u0001\u0003mC:<'\"\u0001\u0013\u0002\t)\fg/Y\u0005\u0003M\u0005\u0012aa\u00142kK\u000e$\bC\u0001\u0015*\u001b\u0005\u0019\u0012B\u0001\u0016\u0014\u0005%!VM\\1oi\u0006\u0003\u0018.A\u0006qKJl\u0017n]:j_:\u001c\bCA\u00171\u001b\u0005q#BA\u0018\u0018\u0003!\u0019XmY;sSRL\u0018BA\u0019/\u0005E\u0001VM]7jgNLwN\\\"iK\u000e\\WM]\u0001\u000ei\u0016t\u0017M\u001c;TKJ4\u0018nY3\u0011\u0005Q:T\"A\u001b\u000b\u0005Y:\u0012aB:feZL7-Z\u0005\u0003qU\u0012Q\u0002V3oC:$8+\u001a:wS\u000e,\u0017A\u0005;f]\u0006tG\u000fT5nSR\u001cVM\u001d<jG\u0016\u0004\"\u0001N\u001e\n\u0005q*$A\u0005+f]\u0006tG\u000fT5nSR\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtD\u0003B B\u0005\u000e\u0003\"\u0001\u0011\u0001\u000e\u0003EAQa\u000b\u0003A\u00021BQA\r\u0003A\u0002MBQ!\u000f\u0003A\u0002i\n!bZ3u)\u0016t\u0017M\u001c;t)\u00051\u0005cA$K\u00196\t\u0001J\u0003\u0002JG\u0005!Q\u000f^5m\u0013\tY\u0005J\u0001\u0003MSN$\bCA'Q\u001b\u0005q%BA(\u0018\u0003\u0019!w.\\1j]&\u0011\u0011K\u0014\u0002\u0007)\u0016t\u0017M\u001c;)\u0005\u0015\u0019\u0006C\u0001+^\u001b\u0005)&B\u0001,X\u0003)\tgN\\8uCRLwN\u001c\u0006\u00031f\u000bAaY8sK*\u0011!lW\u0001\u000b[&\u001c'o\\7fi\u0016\u0014(\"\u0001/\u0002\u0005%|\u0017B\u00010V\u0005\u0015!\u0016.\\3e\u0003%9W\r\u001e+f]\u0006tG\u000f\u0006\u0002MC\")!M\u0002a\u0001G\u0006AA/\u001a8b]RLE\r\u0005\u0002e[:\u0011Qm\u001b\t\u0003M&l\u0011a\u001a\u0006\u0003Qv\ta\u0001\u0010:p_Rt$\"\u00016\u0002\u000bM\u001c\u0017\r\\1\n\u00051L\u0017A\u0002)sK\u0012,g-\u0003\u0002o_\n11\u000b\u001e:j]\u001eT!\u0001\\5)\u0005\u0019\u0019\u0016AB2sK\u0006$X\r\u0006\u0002Mg\")Ao\u0002a\u0001k\u0006iA/\u001a8b]R\u0014V-];fgR\u0004\"A^=\u000e\u0003]T!\u0001_\n\u0002\u000b\u0019|'/\\:\n\u0005i<(!\u0004+f]\u0006tGOU3rk\u0016\u001cH\u000f\u000b\u0002\b'\u00061Q\u000f\u001d3bi\u0016$RA`A\u0003\u0003\u000f\u00012a`A\u0001\u001b\u0005I\u0017bAA\u0002S\n!QK\\5u\u0011\u0015\u0011\u0007\u00021\u0001d\u0011\u0015!\b\u00021\u0001vQ\tA1+\u0001\u0004eK2,G/\u001a\u000b\u0004}\u0006=\u0001\"\u00022\n\u0001\u0004\u0019\u0007FA\u0005T\u0003%9W\r\u001e'j[&$8\u000f\u0006\u0002\u0002\u0018A!qISA\r!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010/\u0005i1m\u001c8gS\u001e,(/\u0019;j_:LA!a\t\u0002\u001e\tYA+\u001a8b]Rd\u0015.\\5uQ\tQ1+\u0001\u0005hKRd\u0015.\\5u)\u0011\tI\"a\u000b\t\u000b\t\\\u0001\u0019A2)\u0005-\u0019\u0016aC2sK\u0006$X\rT5nSR$b!!\u0007\u00024\u0005U\u0002\"\u00022\r\u0001\u0004\u0019\u0007bBA\u001c\u0019\u0001\u0007\u0011\u0011D\u0001\u0006Y&l\u0017\u000e\u001e\u0015\u0003\u0019M\u000b1\"\u001e9eCR,G*[7jiR)a0a\u0010\u0002B!)!-\u0004a\u0001G\"9\u0011qG\u0007A\u0002\u0005e\u0001FA\u0007T\u0003-!W\r\\3uK2KW.\u001b;\u0015\u0007y\fI\u0005C\u0003c\u001d\u0001\u00071\r\u000b\u0002\u000f'\u0006aA.\u001b8l%\u0016\u001cx.\u001e:dKR)a0!\u0015\u0002T!)!m\u0004a\u0001G\"9\u0011QK\bA\u0002\u0005]\u0013\u0001\u00047j].\u0014V-];fgR\u001c\b\u0003B$K\u00033\u00022A^A.\u0013\r\tif\u001e\u0002\u0012)\u0016t\u0017M\u001c;MS:\\'+Z9vKN$\bFA\bTQ\r\u0001\u00111\r\t\u0005\u0003K\n\u0019(\u0004\u0002\u0002h)!\u0011\u0011NA6\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0005\u0003[\ny'A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\t\t(A\u0002pe\u001eLA!!\u001e\u0002h\tQ1i\u001c8ue>dG.\u001a:")
public class TenantApiImpl
implements TenantApi {
    private final PermissionChecker permissions;
    private final TenantService tenantService;
    private final TenantLimitService tenantLimitService;

    @Timed
    public List<Tenant> getTenants() {
        this.permissions.check(PlatformPermissions.ADMIN);
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.tenantService.getAllTenants()).asJava();
    }

    @Timed
    public Tenant getTenant(String tenantId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.tenantService.findTenantById(tenantId);
    }

    @Timed
    public Tenant create(TenantRequest tenantRequest) {
        Checks.checkArgument((tenantRequest != null ? 1 : 0) != 0, (String)"tenantRequest cannot be null", (Object[])new Object[0]);
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.tenantService.createTenant(tenantRequest.getTenantName(), TenantStatus.fromString((String)tenantRequest.getTenantStatus()));
    }

    @Timed
    public void update(String tenantId, TenantRequest tenantRequest) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)tenantId), (String)"Tenant ID cannot be empty", (Object[])new Object[0]);
        Checks.checkArgument((tenantRequest != null ? 1 : 0) != 0, (String)"tenantRequest cannot be null", (Object[])new Object[0]);
        this.permissions.check(PlatformPermissions.ADMIN);
        Tenant toUpdate = new Tenant(tenantId, tenantRequest.getTenantName(), TenantStatus.fromString((String)tenantRequest.getTenantStatus()));
        this.tenantService.updateTenant(toUpdate);
    }

    @Timed
    public void delete(String tenantId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.tenantService.deleteTenant(tenantId);
    }

    @Timed
    public List<TenantLimit> getLimits() {
        this.permissions.check(PlatformPermissions.ADMIN);
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.tenantLimitService.getAllLimits()).asJava();
    }

    @Timed
    public TenantLimit getLimit(String tenantId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.tenantLimitService.findLimitByTenantId(tenantId);
    }

    @Timed
    public TenantLimit createLimit(String tenantId, TenantLimit limit) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.tenantLimitService.createLimit(tenantId, limit);
    }

    @Timed
    public void updateLimit(String tenantId, TenantLimit limit) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.tenantLimitService.updateLimit(tenantId, limit);
    }

    @Timed
    public void deleteLimit(String tenantId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.tenantLimitService.deleteLimit(tenantId);
    }

    @Timed
    public void linkResource(String tenantId, List<TenantLinkRequest> linkRequests) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.tenantService.linkResource(tenantId, linkRequests);
    }

    public TenantApiImpl(PermissionChecker permissions, TenantService tenantService, TenantLimitService tenantLimitService) {
        this.permissions = permissions;
        this.tenantService = tenantService;
        this.tenantLimitService = tenantLimitService;
    }
}

