package com.xebialabs.xlrelease.upgrade.json;

import java.util.Collections;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.upgrade.ImportUpgrade;
import com.xebialabs.xlrelease.upgrade.UpgradeResult;

import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT;

public class XLRelease451ImportAddTemplateViewersFields implements ImportUpgrade {
    private static final String VERSION = "4.5.1";

    @Override
    public UpgradeResult performUpgrade(JSONObject release) throws JSONException {
        JSONArray teams = release.getJSONArray("teams");
        List<String> memberViewers = newArrayList();
        List<String> roleViewers = newArrayList();

        for (int i = 0; i < teams.length(); i++) {
            JSONObject team = teams.getJSONObject(i);
            JSONArray permissions = team.getJSONArray("permissions");

            if (containsPermissions(permissions, XLReleasePermissions.VIEW_TEMPLATE.getPermissionName())) {
                if (team.has("members")) {
                    JSONArray members = team.getJSONArray("members");
                    memberViewers.addAll(getStrings(members));
                }

                if (team.has("roles")) {
                    JSONArray roles = team.getJSONArray("roles");
                    roleViewers.addAll(getStrings(roles));
                }
            }
        }

        release.put("memberViewers", memberViewers);
        release.put("roleViewers", roleViewers);

        return new UpgradeResult(true, Collections.emptyList());
    }

    private List<String> getStrings(JSONArray jsonArrayOfStrings) throws JSONException {
        List<String> strings = newArrayList();

        for (int i = 0; i < jsonArrayOfStrings.length(); i++) {
            strings.add(jsonArrayOfStrings.getString(i));
        }

        return strings;
    }

    private boolean containsPermissions(JSONArray permissions, String permissionName) throws JSONException {
        for (int i = 0; i < permissions.length(); i++) {
            String permission = permissions.getString(i);

            if (permission.equals(permissionName)) {
                return true;
            }
        }

        return false;
    }

    @Override
    public Version getUpgradeVersion() {
        return Version.valueOf(XL_RELEASE_COMPONENT, VERSION);
    }
}
