package com.xebialabs.xlrelease.utils

import com.xebialabs.xlplatform.utils.SecureRandomHolder
import com.xebialabs.xlrelease.utils.TokenTypes.TokenType
import org.apache.commons.codec.binary.Hex
import org.apache.commons.codec.digest.DigestUtils

object TokenGenerator {

  private val DEFAULT_TOKEN_LENGTH = 20

  def generate(tokenType: TokenType): String = {
    val randomBytes = SecureRandomHolder.getRandomByteArray(DEFAULT_TOKEN_LENGTH)
    val prefix = tokenType.toString
    val token = Hex.encodeHexString(randomBytes)
    s"$prefix$token"
  }

  def hash(token: String): String = {
    val tokenHash = DigestUtils.sha384Hex(token)
    s"{SHA-384}$tokenHash"
  }

  def isHashed(token: String): Boolean = token.startsWith("{SHA-")

}
