/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.ManagementApi;
import com.xebialabs.xlrelease.api.v1.forms.DatacenterTargetStateRequest;
import com.xebialabs.xlrelease.api.v1.views.ApplicationStatusView;
import com.xebialabs.xlrelease.api.v1.views.ServiceStatusView;
import com.xebialabs.xlrelease.domain.Datacenter;
import com.xebialabs.xlrelease.domain.DatacenterTargetState;
import com.xebialabs.xlrelease.domain.management.ServiceState$;
import com.xebialabs.xlrelease.domain.management.ServiceStatus;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.DatacenterService;
import com.xebialabs.xlrelease.service.XlrServiceManager;
import java.io.Serializable;
import org.springframework.stereotype.Controller;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005=a\u0001\u0002\u0007\u000e\u0001iA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!A!\u0007\u0001B\u0001B\u0003%1\u0007C\u0003:\u0001\u0011\u0005!\bC\u0003A\u0001\u0011\u0005\u0013\tC\u0003I\u0001\u0011\u0005\u0013\tC\u0003J\u0001\u0011\u0005#\nC\u0003R\u0001\u0011\u0005#\u000bC\u0003`\u0001\u0011\u0005\u0003\rC\u0003w\u0001\u0011\u0005s\u000fC\u0003z\u0001\u0011\u0005#PA\tNC:\fw-Z7f]R\f\u0005/[%na2T!AD\b\u0002\t%l\u0007\u000f\u001c\u0006\u0003!E\t!A^\u0019\u000b\u0005I\u0019\u0012aA1qS*\u0011A#F\u0001\nq2\u0014X\r\\3bg\u0016T!AF\f\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\r\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Y2\u0005\u0005\u0002\u001dC5\tQD\u0003\u0002\u001f?\u0005!A.\u00198h\u0015\u0005\u0001\u0013\u0001\u00026bm\u0006L!AI\u000f\u0003\r=\u0013'.Z2u!\t!S%D\u0001\u0010\u0013\t1sBA\u0007NC:\fw-Z7f]R\f\u0005/[\u0001\u0012q2\u00148+\u001a:wS\u000e,W*\u00198bO\u0016\u0014\bCA\u0015-\u001b\u0005Q#BA\u0016\u0014\u0003\u001d\u0019XM\u001d<jG\u0016L!!\f\u0016\u0003#ac'oU3sm&\u001cW-T1oC\u001e,'/A\teCR\f7-\u001a8uKJ\u001cVM\u001d<jG\u0016\u0004\"!\u000b\u0019\n\u0005ER#!\u0005#bi\u0006\u001cWM\u001c;feN+'O^5dK\u0006Y\u0001/\u001a:nSN\u001c\u0018n\u001c8t!\t!t'D\u00016\u0015\t14#\u0001\u0005tK\u000e,(/\u001b;z\u0013\tATGA\tQKJl\u0017n]:j_:\u001c\u0005.Z2lKJ\fa\u0001P5oSRtD\u0003B\u001e>}}\u0002\"\u0001\u0010\u0001\u000e\u00035AQa\n\u0003A\u0002!BQA\f\u0003A\u0002=BQA\r\u0003A\u0002M\nQa\u001d;beR$\u0012A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0002\u000b\u0006)1oY1mC&\u0011q\t\u0012\u0002\u0005+:LG/\u0001\u0003ti>\u0004\u0018!E1qa2L7-\u0019;j_:\u001cF/\u0019;vgR\t1\n\u0005\u0002M\u001f6\tQJ\u0003\u0002O\u001f\u0005)a/[3xg&\u0011\u0001+\u0014\u0002\u0016\u0003B\u0004H.[2bi&|gn\u0015;biV\u001ch+[3x\u000399W\r\u001e#bi\u0006\u001cWM\u001c;feN$\u0012a\u0015\t\u0004)^KV\"A+\u000b\u0005Y{\u0012\u0001B;uS2L!\u0001W+\u0003\t1K7\u000f\u001e\t\u00035vk\u0011a\u0017\u0006\u00039N\ta\u0001Z8nC&t\u0017B\u00010\\\u0005)!\u0015\r^1dK:$XM]\u0001\u0013g\u0016$H)\u0019;bG\u0016tG/\u001a:Ti\u0006$X\rF\u0002CC:DQAY\u0005A\u0002\r\f!\u0002Z1uC\u000e,g\u000e^3s!\t!7N\u0004\u0002fSB\u0011a\rR\u0007\u0002O*\u0011\u0001.G\u0001\u0007yI|w\u000e\u001e \n\u0005)$\u0015A\u0002)sK\u0012,g-\u0003\u0002m[\n11\u000b\u001e:j]\u001eT!A\u001b#\t\u000b=L\u0001\u0019\u00019\u00029\u0011\fG/Y2f]R,'\u000fV1sO\u0016$8\u000b^1uKJ+\u0017/^3tiB\u0011\u0011\u000f^\u0007\u0002e*\u00111oD\u0001\u0006M>\u0014Xn]\u0005\u0003kJ\u0014A\u0004R1uC\u000e,g\u000e^3s)\u0006\u0014x-\u001a;Ti\u0006$XMU3rk\u0016\u001cH/\u0001\teK2,G/\u001a#bi\u0006\u001cWM\u001c;feR\u0011!\t\u001f\u0005\u0006E*\u0001\raY\u0001\u0011GJ,\u0017\r^3ECR\f7-\u001a8uKJ$\"!W>\t\u000b\t\\\u0001\u0019A2)\u0005\u0001i\bc\u0001@\u0002\f5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011AC:uKJ,w\u000e^=qK*!\u0011QAA\u0004\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA\u0005\u0003\ry'oZ\u0005\u0004\u0003\u001by(AC\"p]R\u0014x\u000e\u001c7fe\u0002")
public class ManagementApiImpl
implements ManagementApi {
    private final XlrServiceManager xlrServiceManager;
    private final DatacenterService datacenterService;
    private final PermissionChecker permissions;

    public void start() {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.xlrServiceManager.startAsync();
    }

    public void stop() {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.xlrServiceManager.stopAsync();
    }

    public ApplicationStatusView applicationStatus() {
        this.permissions.check(PlatformPermissions.ADMIN);
        List<ServiceStatus> serviceStatuses = this.xlrServiceManager.getServicesStatus();
        boolean isRunning = serviceStatuses.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ManagementApiImpl.$anonfun$applicationStatus$1(x$1)));
        List serviceStatusViews = serviceStatuses.map((Function1 & Serializable)serviceStatus -> ServiceStatusView.from((ServiceStatus)serviceStatus));
        return new ApplicationStatusView(Predef$.MODULE$.boolean2Boolean(isRunning), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)serviceStatusViews).asJava());
    }

    public java.util.List<Datacenter> getDatacenters() {
        this.permissions.check(PlatformPermissions.ADMIN);
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.datacenterService.getDatacenters()).asJava();
    }

    public void setDatacenterState(String datacenter, DatacenterTargetStateRequest datacenterTargetStateRequest) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.datacenterService.validateDatacenterStateChange();
        this.datacenterService.setDatacenterState(datacenter, DatacenterTargetState.fromString((String)datacenterTargetStateRequest.getTargetState()));
    }

    public void deleteDatacenter(String datacenter) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.datacenterService.deleteDatacenter(datacenter);
    }

    public Datacenter createDatacenter(String datacenter) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.datacenterService.createDatacenter(datacenter);
    }

    public static final /* synthetic */ boolean $anonfun$applicationStatus$1(ServiceStatus x$1) {
        Enumeration.Value value = x$1.state();
        Enumeration.Value value2 = ServiceState$.MODULE$.Running();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public ManagementApiImpl(XlrServiceManager xlrServiceManager, DatacenterService datacenterService, PermissionChecker permissions) {
        this.xlrServiceManager = xlrServiceManager;
        this.datacenterService = datacenterService;
        this.permissions = permissions;
    }
}

