/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobRow$;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.JobType;
import com.xebialabs.xlrelease.scheduler.NodeId;
import com.xebialabs.xlrelease.scheduler.StopWorkerThread;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.converters.TaskJobConverter;
import com.xebialabs.xlrelease.scheduler.domain.LocalJobRunner$;
import com.xebialabs.xlrelease.scheduler.events.JobCreatedEvent;
import com.xebialabs.xlrelease.scheduler.events.JobFinishedEvent;
import com.xebialabs.xlrelease.scheduler.events.JobReservedEvent;
import com.xebialabs.xlrelease.scheduler.repository.ConfirmJobExecution;
import com.xebialabs.xlrelease.scheduler.repository.DeleteById;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.scheduler.repository.ReserveJob;
import com.xebialabs.xlrelease.scheduler.repository.UnReserveJob;
import com.xebialabs.xlrelease.script.TaskSoftReference;
import com.xebialabs.xlrelease.service.BroadcastService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.pekko.actor.Address;
import org.slf4j.Marker;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@ScalaSignature(bytes="\u0006\u0005\tee\u0001\u0002\u0012$\u00011B\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0003\"A\u0001\n\u0001BC\u0002\u0013\u0005\u0011\n\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003K\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\u0002\u0003-\u0001\u0005\u000b\u0007I\u0011A-\t\u0011\u0001\u0004!\u0011!Q\u0001\niCQ!\u0019\u0001\u0005\u0002\tDq!\u001e\u0001C\u0002\u0013%a\u000fC\u0004\u0002\n\u0001\u0001\u000b\u0011B<\t\u0013\u0005-\u0001A1A\u0005\n\u00055\u0001\u0002CA\u000e\u0001\u0001\u0006I!a\u0004\t\u000f\u0005u\u0001\u0001\"\u0001\u0002 !9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA%\u0001\u0011\u0005\u00111\n\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\t9\u0006\u0001C\u0001\u00033Ba!!\u0019\u0001\t\u00031\bbBA2\u0001\u0011\u0005\u0011Q\r\u0005\n\u0003\u0007\u0003\u0011\u0013!C\u0001\u0003\u000bCq!!'\u0001\t\u0003\tY\nC\u0004\u0002 \u0002!\t!!)\t\u000f\t\r\u0001\u0001\"\u0001\u0003\u0006!9!1\u0003\u0001\u0005\u0002\tU\u0001b\u0002B\f\u0001\u0011\u0005!Q\u0003\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0011\u001d\u0011i\u0003\u0001C\u0001\u0005_AqA!\f\u0001\t\u0003\u0011\u0019\u0004C\u0004\u00038\u0001!\tA!\u000f\t\u000f\t\u0005\u0003\u0001\"\u0003\u0003D!9!1\n\u0001\u0005\n\t5\u0003b\u0002B0\u0001\u0011%!\u0011\r\u0005\b\u0005G\u0002A\u0011\u0002B3\u0005=!UMZ1vYRTuNY)vKV,'B\u0001\u0013&\u0003%\u00198\r[3ek2,'O\u0003\u0002'O\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003Q%\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003)\n1aY8n\u0007\u0001\u0019B\u0001A\u00174wA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t1\u0011I\\=SK\u001a\u0004\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\u000bMdg\r\u000e6\u000b\u0003a\n\u0001b\u001a:jujdW\rZ\u0005\u0003uU\u0012q\u0001T8hO&tw\r\u0005\u0002={5\t1%\u0003\u0002?G\t1aj\u001c3f\u0013\u0012\f\u0001\u0003^1tW*{'mQ8om\u0016\u0014H/\u001a:\u0016\u0003\u0005\u0003\"AQ#\u000e\u0003\rS!\u0001R\u0012\u0002\u0015\r|gN^3si\u0016\u00148/\u0003\u0002G\u0007\n\u0001B+Y:l\u0015>\u00147i\u001c8wKJ$XM]\u0001\u0012i\u0006\u001c8NS8c\u0007>tg/\u001a:uKJ\u0004\u0013!\u00046pEJ+\u0007o\\:ji>\u0014\u00180F\u0001K!\tYe*D\u0001M\u0015\ti5%\u0001\u0006sKB|7/\u001b;pefL!a\u0014'\u0003\u001b){'MU3q_NLGo\u001c:z\u00039QwN\u0019*fa>\u001c\u0018\u000e^8ss\u0002\n\u0001C\u0019:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0011\u0005M3V\"\u0001+\u000b\u0005U+\u0013aB:feZL7-Z\u0005\u0003/R\u0013\u0001C\u0011:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0002#\u0005\u001cGo\u001c:TsN$X-\u001c%pY\u0012,'/F\u0001[!\tYf,D\u0001]\u0015\tiV%\u0001\u0004bGR|'o]\u0005\u0003?r\u0013\u0011#Q2u_J\u001c\u0016p\u001d;f[\"{G\u000eZ3s\u0003I\t7\r^8s'f\u001cH/Z7I_2$WM\u001d\u0011\u0002\rqJg.\u001b;?)\u0015\u0019G-\u001a4h!\ta\u0004\u0001C\u0003@\u0011\u0001\u0007\u0011\tC\u0003I\u0011\u0001\u0007!\nC\u0003R\u0011\u0001\u0007!\u000bC\u0003Y\u0011\u0001\u0007!\f\u000b\u0002hSB\u0011!n]\u0007\u0002W*\u0011A.\\\u0001\u000bC:tw\u000e^1uS>t'B\u00018p\u0003\u001d\u0019wN\u001c;fqRT!\u0001]9\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011A]\u0001\u0004_J<\u0017B\u0001;l\u0005\u0011a\u0015M_=\u0002\u0015}cwnY1m\u0015>\u00147/F\u0001x!\u0011Ax0a\u0001\u000e\u0003eT!A_>\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002}{\u0006!Q\u000f^5m\u0015\u0005q\u0018\u0001\u00026bm\u0006L1!!\u0001z\u0005)!U\r\\1z#V,W/\u001a\t\u0004y\u0005\u0015\u0011bAA\u0004G\t\u0019!j\u001c2\u0002\u0017}cwnY1m\u0015>\u00147\u000fI\u0001\u000b?&\u001c(+\u001e8oS:<WCAA\b!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000bs\u00061\u0011\r^8nS\u000eLA!!\u0007\u0002\u0014\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\f1bX5t%Vtg.\u001b8hA\u000511/\u001e2nSR$B!!\t\u0002(A\u0019a&a\t\n\u0007\u0005\u0015rF\u0001\u0003V]&$\bbBA\u0015\u001b\u0001\u0007\u00111A\u0001\u0004U>\u0014\u0007fA\u0007\u0002.A!\u0011qFA \u001b\t\t\tDC\u0002m\u0003gQA!!\u000e\u00028\u0005!1m\u001c:f\u0015\u0011\tI$a\u000f\u0002\u00155L7M]8nKR,'O\u0003\u0002\u0002>\u0005\u0011\u0011n\\\u0005\u0005\u0003\u0003\n\tDA\u0003US6,G-\u0001\btk\nl\u0017\u000e^#ySN$\u0018N\\4\u0015\t\u0005\u0005\u0012q\t\u0005\b\u0003Sq\u0001\u0019AA\u0002\u0003E\u0019XOY7ji\n\u0013x.\u00193dCN$X\r\u001a\u000b\u0005\u0003C\ti\u0005C\u0004\u0002*=\u0001\r!a\u0001\u0002\u000fI,\u0007\u000f\\1dKR!\u0011\u0011EA*\u0011\u001d\tI\u0003\u0005a\u0001\u0003\u0007A3\u0001EA\u0017\u0003%I7OU;o]&tw\r\u0006\u0002\u0002\\A\u0019a&!\u0018\n\u0007\u0005}sFA\u0004C_>dW-\u00198\u0002\u00131|7-\u00197K_\n\u001c\u0018a\u0002:fg\u0016\u0014h/\u001a\u000b\u0007\u0003\u0007\t9'!\u001b\t\u000f\u0005%2\u00031\u0001\u0002\u0004!I\u00111N\n\u0011\u0002\u0003\u0007\u0011QN\u0001\teVtg.\u001a:JIB!\u0011qNA?\u001d\u0011\t\t(!\u001f\u0011\u0007\u0005Mt&\u0004\u0002\u0002v)\u0019\u0011qO\u0016\u0002\rq\u0012xn\u001c;?\u0013\r\tYhL\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0014\u0011\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005mt&A\tsKN,'O^3%I\u00164\u0017-\u001e7uII*\"!a\"+\t\u00055\u0014\u0011R\u0016\u0003\u0003\u0017\u0003B!!$\u0002\u00166\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*A\u0005v]\u000eDWmY6fI*\u0011AnL\u0005\u0005\u0003/\u000byIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011\"\u001e8SKN,'O^3\u0015\t\u0005\r\u0011Q\u0014\u0005\b\u0003S)\u0002\u0019AA\u0002\u0003\u001d\u0019wN\u001c4je6$b!a)\u0002N\u0006e\bc\u0002\u0018\u0002&\u0006m\u0013\u0011V\u0005\u0004\u0003O{#A\u0002+va2,'\u0007E\u0003/\u0003W\u000by+C\u0002\u0002.>\u0012aa\u00149uS>t\u0007\u0007BAY\u0003w\u0003R\u0001PAZ\u0003oK1!!.$\u0005\u001d!\u0016m]6K_\n\u0004B!!/\u0002<2\u0001AaCA_-\u0005\u0005\t\u0011!B\u0001\u0003\u007f\u00131a\u0018\u00132#\u0011\t\t-a2\u0011\u00079\n\u0019-C\u0002\u0002F>\u0012qAT8uQ&tw\rE\u0002/\u0003\u0013L1!a30\u0005\r\te.\u001f\u0005\b\u0003W2\u0002\u0019AAh!\u0011\t\t.a=\u000f\t\u0005M\u0017Q\u001e\b\u0005\u0003+\f9O\u0004\u0003\u0002X\u0006\rh\u0002BAm\u0003CtA!a7\u0002`:!\u00111OAo\u0013\u0005Q\u0013B\u0001\u0015*\u0013\t1s%C\u0002\u0002f\u0016\naA];o]\u0016\u0014\u0018\u0002BAu\u0003W\fa\u0001Z8nC&t'bAAsK%!\u0011q^Ay\u0003\u001d\u0001\u0018mY6bO\u0016TA!!;\u0002l&!\u0011Q_A|\u0005!\u0011VO\u001c8fe&#'\u0002BAx\u0003cDq!a?\u0017\u0001\u0004\ti0A\u0003k_\nLE\r\u0005\u0003\u0002R\u0006}\u0018\u0002\u0002B\u0001\u0003o\u0014QAS8c\u0013\u0012\faAZ5oSNDG\u0003\u0002B\u0004\u0005\u001f\u0001RALAV\u0005\u0013\u00012\u0001\u0010B\u0006\u0013\r\u0011ia\t\u0002\u0007\u0015>\u0014'k\\<\t\u000f\u0005mx\u00031\u0001\u0002~\"\u001aq#!\f\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005\u0005\u0012\u0001B:u_B\f\u0001bY1oG\u0016d\u0017J\u001a\u000b\u0005\u0003C\u0011i\u0002C\u0004\u0003 i\u0001\rA!\t\u0002\u0013A\u0014X\rZ5dCR,\u0007C\u0002B\u0012\u0005S\t\u0019!\u0004\u0002\u0003&)\u0019!qE>\u0002\u0011\u0019,hn\u0019;j_:LAAa\u000b\u0003&\tI\u0001K]3eS\u000e\fG/Z\u0001\ne\u0016lwN^3K_\n$B!!\t\u00032!9\u0011\u0011F\u000eA\u0002\u0005\rA\u0003BA\u0011\u0005kAq!a?\u001d\u0001\u0004\ti0\u0001\u0003tSj,GC\u0001B\u001e!\rq#QH\u0005\u0004\u0005\u007fy#aA%oi\u0006q\u0011\r\u001a3U_2{7-\u00197K_\n\u001cHCBA\u0011\u0005\u000b\u00129\u0005C\u0004\u0002*y\u0001\r!a\u0001\t\u000f\t%c\u00041\u0001\u0002\\\u0005a!M]8bI\u000e\f7\u000f\u001e&pE\u0006\u0019An\\4\u0015\t\t=#1\f\u000b\u0005\u0003C\u0011\t\u0006\u0003\u0005\u0003T}!\t\u0019\u0001B+\u0003\u0015\u0011Gn\\2l!\u0015q#qKA\u0011\u0013\r\u0011If\f\u0002\ty\tLh.Y7f}!9!QL\u0010A\u0002\u00055\u0014A\u00029sK\u001aL\u00070A\u0007m_\u000e\fGNS8cgNK'0\u001a\u000b\u0003\u0003[\n\u0011\u0002^8UCN\\'j\u001c2\u0015\r\t\u001d$\u0011\u000fB:a\u0011\u0011IG!\u001c\u0011\u000bq\n\u0019La\u001b\u0011\t\u0005e&Q\u000e\u0003\f\u0005_\n\u0013\u0011!A\u0001\u0006\u0003\tyLA\u0002`IIBq!!\u000b\"\u0001\u0004\t\u0019\u0001C\u0004\u0003v\u0005\u0002\rA!\u0003\u0002\u0007I|w\u000fK\u0002\u0001\u0005s\u0002BAa\u001f\u0003\u00026\u0011!Q\u0010\u0006\u0004\u0005\u007fz\u0017AC:uKJ,w\u000e^=qK&!!1\u0011B?\u0005%\u0019u.\u001c9p]\u0016tG\u000fK\u0004\u0001\u0005\u000f\u0013iIa$\u0011\u0007)\u0014I)C\u0002\u0003\f.\u0014QaU2pa\u0016\f\u0011\u0002\u001d:pqflu\u000eZ3%\u0005\tE\u0015\u0002\u0002BJ\u0005+\u000bA\u0002V!S\u000f\u0016#vl\u0011'B'NS1Aa&l\u0003=\u00196m\u001c9fIB\u0013x\u000e_=N_\u0012,\u0007")
public class DefaultJobQueue
implements Logging,
NodeId {
    private final TaskJobConverter taskJobConverter;
    private final JobRepository jobRepository;
    private final BroadcastService broadcastService;
    private final ActorSystemHolder actorSystemHolder;
    private final DelayQueue<Job> _localJobs;
    private final AtomicBoolean _isRunning;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String nodeId() {
        return NodeId.nodeId$(this);
    }

    @Override
    public String convertAddressToNodeId(Address address) {
        return NodeId.convertAddressToNodeId$(this, address);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultJobQueue defaultJobQueue = this;
        synchronized (defaultJobQueue) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public TaskJobConverter taskJobConverter() {
        return this.taskJobConverter;
    }

    public JobRepository jobRepository() {
        return this.jobRepository;
    }

    @Override
    public ActorSystemHolder actorSystemHolder() {
        return this.actorSystemHolder;
    }

    private DelayQueue<Job> _localJobs() {
        return this._localJobs;
    }

    private AtomicBoolean _isRunning() {
        return this._isRunning;
    }

    @Timed
    public void submit(Job job) {
        this.logger().debug((Function0 & Serializable)() -> "submitted job " + job);
        Job job2 = job;
        if (job2 instanceof TaskJob) {
            TaskJob taskJob = (TaskJob)job2;
            JobRow qual$1 = JobRow$.MODULE$.apply(taskJob);
            String x$1 = this.nodeId();
            long x$2 = qual$1.copy$default$1();
            JobType x$3 = qual$1.copy$default$3();
            JobStatus x$4 = qual$1.copy$default$4();
            long x$5 = qual$1.copy$default$5();
            Instant x$6 = qual$1.copy$default$6();
            Instant x$7 = qual$1.copy$default$7();
            Instant x$8 = qual$1.copy$default$8();
            Instant x$9 = qual$1.copy$default$9();
            String x$10 = qual$1.copy$default$10();
            Integer x$11 = qual$1.copy$default$11();
            String x$12 = qual$1.copy$default$12();
            String x$13 = qual$1.copy$default$13();
            taskJob.setId(this.jobRepository().create(qual$1.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13)).id());
        }
        this.addToLocalJobs(job, job.broadcast());
    }

    public void submitExisting(Job job) {
        this.logger().debug((Function0 & Serializable)() -> "submitted existing job " + job);
        this.removeJob(job);
        this.addToLocalJobs(job, job.broadcast());
    }

    public void submitBroadcasted(Job job) {
        this.logger().debug((Function0 & Serializable)() -> "submitted broadcasted job " + job);
        this.removeJob(job);
        this.addToLocalJobs(job, false);
    }

    @Timed
    public void replace(Job job) {
        this.logger().debug((Function0 & Serializable)() -> "replaced job " + job);
        JobRow qual$1 = JobRow$.MODULE$.apply(job);
        String x$1 = this.nodeId();
        Object x$2 = null;
        long x$3 = qual$1.copy$default$1();
        JobType x$4 = qual$1.copy$default$3();
        JobStatus x$5 = qual$1.copy$default$4();
        long x$6 = qual$1.copy$default$5();
        Instant x$7 = qual$1.copy$default$6();
        Instant x$8 = qual$1.copy$default$7();
        Instant x$9 = qual$1.copy$default$8();
        Instant x$10 = qual$1.copy$default$9();
        String x$11 = qual$1.copy$default$10();
        Integer x$12 = qual$1.copy$default$11();
        String x$13 = qual$1.copy$default$12();
        long newJobId = this.jobRepository().replace(qual$1.copy(x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, null)).id();
        this.removeJob(job);
        job.setId(newJobId);
        this.addToLocalJobs(job, false);
    }

    public boolean isRunning() {
        return this._isRunning().get();
    }

    public DelayQueue<Job> localJobs() {
        return this._localJobs();
    }

    public Job reserve(Job job, String runnerId) {
        Try<JobRow> lockAttempt = this.jobRepository().update(new ReserveJob(JobRow$.MODULE$.apply(job), this.nodeId(), runnerId));
        Try<JobRow> try_ = lockAttempt;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw exception;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            JobRow row = (JobRow)success.value();
            TaskJob<?> lockedJob = this.toTaskJob(job, row);
            this.broadcastService.broadcast(new JobReservedEvent(lockedJob.id()), false);
            this.removeJob(job);
            return lockedJob;
        }
        throw new MatchError(try_);
    }

    public String reserve$default$2() {
        return LocalJobRunner$.MODULE$.getId();
    }

    public Job unReserve(Job job) {
        Try<JobRow> updatedRow = this.jobRepository().update(new UnReserveJob(JobRow$.MODULE$.apply(job)));
        Try<JobRow> try_ = updatedRow;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw exception;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            JobRow row = (JobRow)success.value();
            return this.toTaskJob(job, row);
        }
        throw new MatchError(try_);
    }

    public Tuple2<Object, Option<TaskJob<?>>> confirm(String runnerId, long jobId) {
        Try confirmationResult = Try$.MODULE$.apply((Function0 & Serializable)() -> (JobRow)this.jobRepository().read(jobId).get()).flatMap((Function1 & Serializable)jobRow -> this.jobRepository().update(new ConfirmJobExecution((JobRow)jobRow, runnerId)).map((Function1 & Serializable)confirmedRow -> confirmedRow));
        Try try_ = confirmationResult;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            this.logger().warn((Function0 & Serializable)() -> "Unable to confirm job " + jobId, (Function0 & Serializable)() -> ex);
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)None$.MODULE$);
        }
        if (try_ instanceof Success) {
            None$ none$;
            Success success = (Success)try_;
            JobRow row = (JobRow)success.value();
            Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> this.taskJobConverter().fromJobRow(row, this.taskJobConverter().fromJobRow$default$2()));
            if (try_2 instanceof Failure) {
                none$ = None$.MODULE$;
            } else if (try_2 instanceof Success) {
                Success success2 = (Success)try_2;
                TaskJob value = (TaskJob)success2.value();
                none$ = Option$.MODULE$.apply((Object)value);
            } else {
                throw new MatchError((Object)try_2);
            }
            None$ maybeJob = none$;
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)maybeJob);
        }
        throw new MatchError((Object)try_);
    }

    @Timed
    public Option<JobRow> finish(long jobId) {
        this.logger().debug((Function0 & Serializable)() -> "finishing job " + jobId);
        this.removeJob(jobId);
        Option<JobRow> maybeJobRow = this.jobRepository().read(jobId);
        maybeJobRow.foreach((Function1 & Serializable)jobRow -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.jobRepository().delete(new DeleteById(jobRow.id()));
            $this.broadcastService.broadcast(new JobFinishedEvent(jobRow.executionId(), jobRow.id()), true);
        }).recover((PartialFunction)new Serializable(this, jobId){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultJobQueue $outer;
            private final long jobId$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.logger().error((Function0 & Serializable)() -> "Unable to finish job " + $this.jobId$2, (Function0 & Serializable)() -> A1);
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.jobId$2 = jobId$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.scheduler.DefaultJobQueue$$anonfun$$nestedInanonfun$finish$2$1 ), $anonfun$applyOrElse$2(java.lang.Throwable )}, serializedLambda);
            }
        }));
        return maybeJobRow;
    }

    public void start() {
        this.logger().debug((Function0 & Serializable)() -> "starting job queue");
        this._isRunning().set(true);
    }

    public void stop() {
        this.logger().debug((Function0 & Serializable)() -> "stopping job queue");
        this._isRunning().set(false);
    }

    public void cancelIf(Predicate<Job> predicate) {
        this.log("cancelIf", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.localJobs().removeIf(predicate));
    }

    public void removeJob(Job job) {
        this.log("removeJob", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.localJobs().remove(job));
    }

    public void removeJob(long jobId) {
        this.log("removeJob by id", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.localJobs().removeIf(x$1 -> x$1.id() == jobId));
    }

    public int size() {
        return this.localJobs().size();
    }

    private void addToLocalJobs(Job job, boolean broadcastJob) {
        this.log("addToLocalJobs", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (this.localJobs().contains(job) && !(job instanceof StopWorkerThread)) {
                IllegalStateException ex = new IllegalStateException("Queue already contains job " + job);
                this.logger().error((Function0 & Serializable)() -> "Please report an error.", (Function0 & Serializable)() -> ex);
            }
            this.localJobs().add(job);
            if (broadcastJob) {
                $this.broadcastService.broadcast(new JobCreatedEvent(job), false);
                return;
            }
        });
    }

    private void log(String prefix, Function0<BoxedUnit> block) {
        this.logger().trace((Function0 & Serializable)() -> prefix + ": before " + this.localJobsSize());
        try {
            block.apply$mcV$sp();
        }
        finally {
            this.logger().trace((Function0 & Serializable)() -> prefix + ": after: " + this.localJobsSize());
        }
    }

    private String localJobsSize() {
        return this.size() + ": " + CollectionConverters$.MODULE$.IteratorHasAsScala(this.localJobs().iterator()).asScala().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.id())).mkString(",");
    }

    private TaskJob<?> toTaskJob(Job job, JobRow row) {
        TaskJob<?> taskJob;
        Job job2 = job;
        if (job2 instanceof TaskJob) {
            TaskJob taskJob2 = (TaskJob)job2;
            taskJob = this.taskJobConverter().fromJobRow(row, (Option<TaskSoftReference<? extends Task>>)new Some(taskJob2.taskRef()));
        } else {
            taskJob = this.taskJobConverter().fromJobRow(row, this.taskJobConverter().fromJobRow$default$2());
        }
        TaskJob<?> updatedJob = taskJob;
        return updatedJob;
    }

    public DefaultJobQueue(TaskJobConverter taskJobConverter, JobRepository jobRepository, BroadcastService broadcastService, @Lazy ActorSystemHolder actorSystemHolder) {
        this.taskJobConverter = taskJobConverter;
        this.jobRepository = jobRepository;
        this.broadcastService = broadcastService;
        this.actorSystemHolder = actorSystemHolder;
        Logging.$init$((Logging)this);
        NodeId.$init$(this);
        this._localJobs = new DelayQueue();
        this._isRunning = new AtomicBoolean(true);
    }
}

