package com.xebialabs.xlrelease.actors.kryoserializers

import com.esotericsoftware.kryo.kryo5.io.{Input, Output}
import com.esotericsoftware.kryo.kryo5.{Kryo, Serializer, SerializerFactory}
import com.xebialabs.xlrelease.repository.proxy.{CiReferenceProxyFactory, ResolvableConfigurationItemReference, ResolvableLazyConfigurationItem}
import com.xebialabs.xlrelease.serialization.json.repository.ResolverRepository
import com.xebialabs.xlrelease.service.ServiceStarter
import com.xebialabs.xlrelease.support.pekko.spring.ScalaSpringSupport
import org.springframework.context.{ApplicationContext, ApplicationContextAware, SmartLifecycle}

import scala.beans.BeanProperty


object ResolvableLazyConfigurationItemSerializer extends Serializer[ResolvableLazyConfigurationItem]
  with ScalaSpringSupport with ApplicationContextAware with SmartLifecycle {

  private lazy val proxyFactory: CiReferenceProxyFactory = springBean[CiReferenceProxyFactory]
  private lazy val resolverRepository: ResolverRepository = springBean[ResolverRepository]

  @BeanProperty
  var applicationContext: ApplicationContext = _

  override def write(kryo: Kryo, output: Output, objectInstance: ResolvableLazyConfigurationItem): Unit = {
    val resolvableLazyConfigurationItem = objectInstance
    val resolvableLazyConfigurationItemReference = resolvableLazyConfigurationItem.get$resolvableConfigurationItemReference()
    kryo.writeClassAndObject(output, resolvableLazyConfigurationItemReference)
  }

  override def read(kryo: Kryo, input: Input, objectType: Class[_ <: ResolvableLazyConfigurationItem]): ResolvableLazyConfigurationItem = {
    val resolvableConfigurationItemReference = kryo.readClassAndObject(input).asInstanceOf[ResolvableConfigurationItemReference]
    val proxy = proxyFactory.proxy(resolverRepository, resolvableConfigurationItemReference).asInstanceOf[ResolvableLazyConfigurationItem]
    proxy
  }

  override def start(): Unit = ()

  override def stop(): Unit = ()

  override def isRunning: Boolean = true

  // make sure serializer has application context populated before we access it as a Scala object in KryoInit
  override def getPhase(): Int = ServiceStarter.LIFECYCLE_PHASE - 1

  override def copy(kryo: Kryo, original: ResolvableLazyConfigurationItem): ResolvableLazyConfigurationItem = {
    super.copy(kryo, original)
  }
}

class ResolvableLazyConfigurationItemSerializerFactory extends SerializerFactory[Serializer[ResolvableLazyConfigurationItem]] {
  override def newSerializer(kryo: Kryo, `type`: Class[_]): Serializer[ResolvableLazyConfigurationItem] = {
    ResolvableLazyConfigurationItemSerializer
  }

  override def isSupported(sType: Class[_]): Boolean = {
    true
  }
}
