package com.xebialabs.xlrelease.domain.tasks.createrelease;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.tasks.TaskExecutor;
import com.xebialabs.xlrelease.scheduler.CreateReleaseTaskJob;
import com.xebialabs.xlrelease.scheduler.WorkManager;
import com.xebialabs.xlrelease.script.TaskSoftReference;

@Component
public class CreateReleaseTaskExecutor implements TaskExecutor<CreateReleaseTask> {
    private WorkManager workManager;

    @Autowired
    public CreateReleaseTaskExecutor(WorkManager workManager) {
        this.workManager = workManager;
    }

    @Override
    public Class<CreateReleaseTask> getTaskClass() {
        return CreateReleaseTask.class;
    }

    @Override
    public void execute(TaskSoftReference<CreateReleaseTask> taskRef) {
        workManager.submit(new CreateReleaseTaskJob(taskRef));
    }
}
